/* SPDX-License-Identifier: GPL-2.0-only OR MIT */

#ifndef SOC_MEDIATEK_COMMON_DP_DPTX_REG_V2_H
#define SOC_MEDIATEK_COMMON_DP_DPTX_REG_V2_H

#include <soc/dptx_reg_common.h>

#define WAIT_AUX_READY_RETRY_TIMES			5
#define PHYD_DIG_GLB_OFFSET				0x1400
#define SEC_OFFSET					0x4000
#define IPMUX_CONTROL					(PHYD_DIG_GLB_OFFSET + 0x98)
#define EDPTX_DSI_PHYD_SEL_FLDMASK			0x1
#define EDPTX_DSI_PHYD_SEL_FLDMASK_POS			0
#define TOP_OFFSET					0x2000
#define MTK_DP_TOP_IRQ_MASK				0x202C
#define ENCODER_IRQ_MSK					BIT(0)
#define TRANS_IRQ_MSK					BIT(1)
#define EDP_TX_TOP_CLKGEN_0				0x2074
#define DP_PHY_DIG_PLL_CTL_1				0x1414
#define DP_PHY_DIG_SW_RST				0x1438
#define RGS_BG_CORE_EN_READY_MASK			BIT(0)
#define REG_2004_TOP_SWING_EMP				0x2004
#define DP_TX0_VOLT_SWING_MASK				GENMASK(1, 0)
#define DP_TX0_PRE_EMPH_MASK				GENMASK(3, 2)
#define DP_TX1_VOLT_SWING_MASK				GENMASK(9, 8)
#define DP_TX1_PRE_EMPH_MASK				GENMASK(11, 10)
#define DP_TX2_VOLT_SWING_MASK				GENMASK(17, 16)
#define DP_TX2_PRE_EMPH_MASK				GENMASK(19, 18)
#define DP_TX3_VOLT_SWING_MASK				GENMASK(25, 24)
#define DP_TX3_PRE_EMPH_MASK				GENMASK(27, 26)
#define REG_3000_DP_ENCODER0_P0				0x3000
#define REG_BS_SYMBOL_CNT_RESET				BIT(7)
#define REG_3004_DP_ENCODER0_P0				0x3004
#define DP_TX_ENCODER_4P_RESET_SW_DP_ENC0_P0		BIT(9)
#define REG_3008_DP_ENCODER0_P0				0x3008
#define REG_300C_DP_ENCODER0_P0				0x300C
#define REG_3010_DP_ENCODER0_P0				0x3010
#define REG_3014_DP_ENCODER0_P0				0x3014
#define REG_3018_DP_ENCODER0_P0				0x3018
#define REG_301C_DP_ENCODER0_P0				0x301C
#define REG_3020_DP_ENCODER0_P0				0x3020
#define REG_3024_DP_ENCODER0_P0				0x3024
#define REG_3028_DP_ENCODER0_P0				0x3028
#define HSP_SW_DP_ENCODER0_P0_FLDMASK			0x8000
#define HSP_SW_DP_ENCODER0_P0_FLDMASK_POS		15
#define REG_302C_DP_ENCODER0_P0				0x302C
#define REG_3030_DP_ENCODER0_P0				0x3030
#define REG_3034_DP_ENCODER0_P0				0x3034
#define DP_TEST_COLOR_FORMAT_MASK			(3 << 1)
#define DP_TEST_COLOR_FORMAT_SHIFT			1
#define REG_303C_DP_ENCODER0_P0				0x303C
#define REG_3040_DP_ENCODER0_P0				0x3040
#define REG_3044_DP_ENCODER0_P0				0x3044
#define REG_3048_DP_ENCODER0_P0				0x3048
#define REG_304C_DP_ENCODER0_P0				0x304C
#define VBID_VIDEO_MUTE_DP_ENC0_4P_MASK			BIT(2)
#define REG_3050_DP_ENCODER0_P0				0x3050
#define REG_3054_DP_ENCODER0_P0				0x3054
#define REG_3064_DP_ENCODER0_P0				0x3064
#define REG_3154_DP_ENCODER0_P0				0x3154
#define REG_3158_DP_ENCODER0_P0				0x3158
#define REG_315C_DP_ENCODER0_P0				0x315C
#define REG_3160_DP_ENCODER0_P0				0x3160
#define REG_3164_DP_ENCODER0_P0				0x3164
#define REG_3168_DP_ENCODER0_P0				0x3168
#define REG_316C_DP_ENCODER0_P0				0x316C
#define REG_3170_DP_ENCODER0_P0				0x3170
#define REG_3174_DP_ENCODER0_P0				0x3174
#define REG_3178_DP_ENCODER0_P0				0x3178
#define REG_31EC_DP_ENCODER0_P0				0x31EC
#define REG_3300_DP_ENCODER1_P0				0x3300
#define REG_3364_DP_ENCODER1_P0				0x3364
#define REG_3368_DP_ENCODER1_P0				0x3368
#define BS2BS_MODE_DP_ENC1_4P_VAL			1
#define BS2BS_MODE_DP_ENCODER1_P0_FLDMASK		0x3000
#define DP_I_MODE_ENABLE				BIT(6)
#define REG_33C0_DP_ENCODER1_P0				0x33C0
#define REG_33C4_DP_ENCODER1_P0				0x33C4
#define REG_33C8_DP_ENCODER1_P0				0x33C8
#define REG_3400_DP_TRANS_P0				0x3400
#define PATTERN1_EN_DP_TRANS_4P_TPS1			BIT(12)
#define PATTERN2_EN_DP_TRANS_4P_TPS2			BIT(13)
#define PATTERN3_EN_DP_TRANS_4P_TPS3			BIT(14)
#define PATTERN4_EN_DP_TRANS_4P_TPS4			BIT(15)
#define PATTERN_EN_DP_TRANS_4P_MASK			GENMASK(15, 12)
#define REG_3404_DP_TRANS_P0				0x3404
#define REG_340C_DP_TRANS_P0				0x340C
#define REG_3418_DP_TRANS_P0				0x3418
#define REG_342C_DP_TRANS_P0				0x342C
#define REG_34A4_DP_TRANS_P0				0x34A4
#define REG_3540_DP_TRANS_P0				0x3540
#define REG_3580_DP_TRANS_P0				0x3580
#define POST_MISC_DATA_LANE0_OV_DP_TRANS_4P_MASK	BIT(8)
#define POST_MISC_DATA_LANE1_OV_DP_TRANS_4P_MASK	BIT(9)
#define POST_MISC_DATA_LANE2_OV_DP_TRANS_4P_MASK	BIT(10)
#define POST_MISC_DATA_LANE3_OV_DP_TRANS_4P_MASK	BIT(11)
#define POST_MISC_DATA_LANE_OV_DP_TRANS_4P_MASK		GENMASK(11, 8)
#define REG_35F0_DP_TRANS_P0				0x35F0
#define REG_360C_AUX_TX_P0				0x360C
#define REG_3614_AUX_TX_P0				0x3614
#define AUX_RX_UI_CNT_THR_AUX_FOR_26M			14
#define REG_3618_AUX_TX_P0				0x3618
#define AUX_RX_FIFO_FULL_AUX_TX_P0_FLDMASK		0x200
#define REG_3620_AUX_TX_P0				0x3620
#define AUX_RD_MODE_AUX_TX_P0_FLDMASK			0x200
#define AUX_RD_MODE_AUX_TX_P0_FLDMASK_POS		9
#define AUX_RX_FIFO_READ_PULSE_TX_P0_FLDMASK		0x100
#define AUX_RX_FIFO_R_PULSE_TX_P0_FLDMASK_POS		8
#define REG_3624_AUX_TX_P0				0x3624
#define REG_3628_AUX_TX_P0				0x3628
#define REG_362C_AUX_TX_P0				0x362C
#define AUX_NO_LENGTH_AUX_TX_P0_FLDMASK			0x1
#define AUX_NO_LENGTH_AUX_TX_P0_FLDMASK_POS		0
#define REG_3630_AUX_TX_P0				0x3630
#define AUX_TX_REQUEST_READY_AUX_TX_P0_FLDMASK		0x8
#define AUX_TX_REQUEST_READY_AUX_TX_P0_FLDMASK_POS	3
#define REG_3634_AUX_TX_P0				0x3634
#define AUX_TX_OVER_SAMPLE_RATE_FOR_26M			25
#define REG_3640_AUX_TX_P0				0x3640
#define AUX_RX_RECV_COMPLETE_IRQ_TX_P0_FLDMASK		0x40
#define AUX_400US_TIMEOUT_IRQ_AUX_TX_P0_FLDMASK		0x1
#define REG_3644_AUX_TX_P0				0x3644
#define REG_3648_AUX_TX_P0				0x3648
#define REG_364C_AUX_TX_P0				0x364C
#define HPD_INT_THD_FLDMASK_VAL				0x32
#define HPD_INT_THD_FLDMASK				0x3F0
#define REG_3650_AUX_TX_P0				0x3650
#define MCU_REQUEST_DATA_NUM_AUX_TX_P0_FLDMASK		0xf000
#define MCU_REQ_DATA_NUM_AUX_TX_P0_FLDMASK_POS		12
#define MCU_ACK_TRANSACTION_COMPLETE_AUX_TX_P0_FLDMASK	0x100
#define MCU_ACK_TRAN_COMPLETE_AUX_TX_P0_FLDMASK_POS	8
#define REG_3658_AUX_TX_P0				0x3658
#define REG_366C_AUX_TX_P0				0x366C
#define XTAL_FREQ_DP_TX_AUX_366C_VALUE			0x68
#define XTAL_FREQ_DP_TX_AUX_366C_MASK			0xFF00
#define REG_367C_AUX_TX_P0				0x367C
#define HPD_CONN_THD_AUX_TX_P0_FLDMASK_POS		5
#define HPD_CONN_THD_AUX_TX_P0_FLDMASK			0x3c0
#define REG_3690_AUX_TX_P0				0x3690
#define RX_REPLY_COMPLETE_MODE_AUX_TX_4P		BIT(8)
#define REG_36A0_AUX_TX_4P				0x36A0
#define REG_3704_AUX_TX_P0				0x3704
#define AUX_TX_FIFO_WRITE_DATA_TOGGLE_AUX_TX_P0_FLDMASK 0x2
#define AUX_TX_FIFO_NEW_MODE_EN_AUX_TX_P0_FLDMASK	0x4
#define AUX_TX_FIFO_NEW_MODE_EN_AUX_TX_P0_FLDMASK_POS	2
#define REG_3708_AUX_TX_P0				0x3708
#define REG_37A0_AUX_TX_P0				0x37A0
#define HPD_DISC_THD_AUX_TX_P0_FLDMASK_POS		5
#define HPD_DISC_THD_AUX_TX_P0_FLDMASK			0xF0
#define REG_37C8_AUX_TX_P0				0x37C8
#define MTK_ATOP_EN_AUX_TX_4P				BIT(0)
#define REG_3F04_DP_ENC_4P_3				0x3F04
#define REG_3F08_DP_ENC_4P_3				0x3F08
#define REG_3F0C_DP_ENC_4P_3				0x3F0C
#define REG_3F10_DP_ENC_4P_3				0x3F10
#define REG_3F28_DP_ENC_4P_3				0x3F28
#define REG_3F44_DP_ENC_4P_3				0x3F44
#define PHY_PWR_STATE_OW_EN_DP_ENC_4P_3			BIT(2)
#define PHY_PWR_STATE_OW_EN_DP_ENC_4P_3_MASK		BIT(2)
#define PHY_PWR_STATE_OW_VALUE_DP_ENC_4P_3_MASK		GENMASK(4, 3)
#define REG_3F80_DP_ENC_4P_3				0x3F80
#define PSR_PATGEN_AVT_EN_FLDMASK			0x20
#define REG_3FF8_DP_ENC_4P_3				0x3FF8
#define PHY_STATE_W_1_DP_ENC_4P_3			BIT(6)
#define PHY_STATE_W_1_DP_ENC_4P_3_MASK			BIT(6)
#define DVO_ON_W_1_FLDMASK				0x20
#define XTAL_FREQ_FOR_PSR_DP_ENC_4P_3_VALUE		25
#define XTAL_FREQ_FOR_PSR_DP_ENC_4P_3_MASK		0x3E00
#define PHYD_DIG_LAN0_OFFSET				0x1000
#define PHYD_DIG_LAN1_OFFSET				0x1100
#define PHYD_DIG_LAN2_OFFSET				0x1200
#define PHYD_DIG_LAN3_OFFSET				0x1300
#define EDP_TX_LN_VOLT_SWING_VAL_MASK			GENMASK(2, 1)
#define EDP_TX_LN_VOLT_SWING_VAL_SHIFT			1
#define DP_TX_TOP_APB_WSTRB				(TOP_OFFSET + 0x10)
#define DP_TX_TOP_RESET_AND_PROBE			(TOP_OFFSET + 0x20)
#define DP_TX_SECURE_REG11				(SEC_OFFSET + 0x2C)
#define DP_LANE_COUNT_ENHANCED_FRAME_EN			(1 << 7)
#define DPCD_00000					0x00000
#define DPCD_0000E					0x0000E
#define DPCD_00021					0x00021
#define DPCD_00100					0x00100
#define DPCD_00101					0x00101
#define DPCD_00102					0x00102
#define DP_TRAINING_PATTERN_DISABLE			0
#define DP_TRAINING_PATTERN_1				1
#define DP_TRAINING_PATTERN_2				2
#define DP_TRAINING_PATTERN_3				3 /* 1.2 */
#define DP_TRAINING_PATTERN_4				7 /* 1.4 */
#define DP_LINK_SCRAMBLING_DISABLE			BIT(5)
#define DPCD_00103					0x00103
#define DP_TRAIN_VOLTAGE_SWING_SHIFT			0
#define DP_TRAIN_MAX_SWING_REACHED			BIT(2)
#define DP_TRAIN_PRE_EMPHASIS_SHIFT			3
#define DP_TRAIN_MAX_PRE_EMPHASIS_REACHED		BIT(5)
#define DPCD_00107					0x00107
#define DP_SPREAD_AMP_0_5				BIT(4)
#define DPCD_00200					0x00200
#define DPCD_00202					0x00202
#define DPCD_00206					0x00206
#define DP_ADJUST_VOLTAGE_SWING_LANE0_MASK		0x03
#define DP_ADJUST_PRE_EMPHASIS_LANE0_MASK		0x0C
#define DP_ADJUST_PRE_EMPHASIS_LANE0_SHIFT		2
#define DP_ADJUST_VOLTAGE_SWING_LANE1_SHIFT		4
#define DPCD_00600					0x00600
#define DPCD_02002					0x02002
#define DPCD_02003					0x02003

#endif /* SOC_MEDIATEK_COMMON_DP_DPTX_REG_V2_H */
