/* SPDX-License-Identifier: GPL-2.0-only */

#include <mipi/panel.h>

struct panel_serializable_data BOE_NS130069_M00 = {
	.edid = {
		.ascii_string = "NS130069",
		.manufacturer_name = "BOE",
		.panel_bits_per_color = 10,
		.panel_bits_per_pixel = 24,
		.mode = {
			.pixel_clock = 1096243,
			.lvds_dual_channel = 0,
			.refresh = 120,
			.ha = 3504, .hbl = 240, .hso = 104, .hspw = 8,
			.va = 2190, .vbl = 250, .vso = 60, .vspw = 4,
			.phsync = '-', .pvsync = '-',
			.x_mm = 127, .y_mm = 203,
		},
	},
	.init = {
		PANEL_DCS(0xFF, 0x20),
		PANEL_DCS(0xFB, 0x01),
		PANEL_DCS(0x01, 0x44),
		PANEL_DCS(0x05, 0x01),
		PANEL_DCS(0x07, 0x41),
		PANEL_DCS(0x08, 0x23),
		PANEL_DCS(0x0D, 0x73),
		PANEL_DCS(0x0E, 0x10),
		PANEL_DCS(0x0F, 0x82),
		PANEL_DCS(0x10, 0x46),
		PANEL_DCS(0x1F, 0x00, 0x00, 0x00),
		PANEL_DCS(0x30, 0x10),
		PANEL_DCS(0x32, 0x72),
		PANEL_DCS(0x58, 0x43),
		PANEL_DCS(0x65, 0x66),
		PANEL_DCS(0x69, 0xDD),
		PANEL_DCS(0x6A, 0x73),
		PANEL_DCS(0x6B, 0x71),
		PANEL_DCS(0x6D, 0x66),
		PANEL_DCS(0x6E, 0x20),
		PANEL_DCS(0x78, 0x93),
		PANEL_DCS(0x7D, 0x99),
		PANEL_DCS(0x95, 0xFF),
		PANEL_DCS(0x96, 0xFF),
		PANEL_DCS(0xFF, 0x22),
		PANEL_DCS(0xFB, 0x01),
		PANEL_DCS(0x1E, 0x91),
		PANEL_DCS(0x1F, 0x05),
		PANEL_DCS(0x2F, 0x02),
		PANEL_DCS(0x30, 0x6A),
		PANEL_DCS(0x31, 0x02),
		PANEL_DCS(0x32, 0x28),
		PANEL_DCS(0x33, 0x03),
		PANEL_DCS(0x34, 0x4A),
		PANEL_DCS(0x6E, 0x13),
		PANEL_DCS(0x6F, 0x04),
		PANEL_DCS(0x70, 0x47),
		PANEL_DCS(0x71, 0x04),
		PANEL_DCS(0x73, 0x04),
		PANEL_DCS(0x75, 0x00),
		PANEL_DCS(0x76, 0x04),
		PANEL_DCS(0x8A, 0x04),
		PANEL_DCS(0x8C, 0x04),
		PANEL_DCS(0x8E, 0xF3),
		PANEL_DCS(0x8F, 0x23),
		PANEL_DCS(0x90, 0x23),
		PANEL_DCS(0x91, 0x23),
		PANEL_DCS(0x92, 0x23),
		PANEL_DCS(0x93, 0x23),
		PANEL_DCS(0x96, 0x1A),
		PANEL_DCS(0x9D, 0x1A),
		PANEL_DCS(0x9F, 0x4C),
		PANEL_DCS(0xA0, 0x17),
		PANEL_DCS(0xA5, 0x09),
		PANEL_DCS(0xA6, 0x10),
		PANEL_DCS(0xA7, 0x16),
		PANEL_DCS(0xA9, 0x50),
		PANEL_DCS(0xAA, 0x5C),
		PANEL_DCS(0xAB, 0x4A),
		PANEL_DCS(0xAD, 0x10),
		PANEL_DCS(0xB0, 0x0F, 0x0B, 0x0F, 0x0F),
		PANEL_DCS(0xB1, 0xD7, 0xA8, 0xD7, 0xD7),
		PANEL_DCS(0xB2, 0x0E, 0x0A, 0x0E, 0x0E),
		PANEL_DCS(0xB3, 0xD1, 0xC0, 0xD1, 0xD1),
		PANEL_DCS(0xB4, 0x0F, 0x0B, 0x0F, 0x0F),
		PANEL_DCS(0xB5, 0x3D, 0x2C, 0x3D, 0x3D),
		PANEL_DCS(0xB8, 0x03),
		PANEL_DCS(0xB9, 0x6C, 0xA8),
		PANEL_DCS(0xBA, 0x6C),
		PANEL_DCS(0xBB, 0x6C),
		PANEL_DCS(0xBC, 0x02),
		PANEL_DCS(0xBD, 0x6C),
		PANEL_DCS(0xBE, 0x0B),
		PANEL_DCS(0xBF, 0x6C),
		PANEL_DCS(0xC1, 0x6C),
		PANEL_DCS(0xC2, 0x0C),
		PANEL_DCS(0xC3, 0x6C),
		PANEL_DCS(0xC6, 0x02),
		PANEL_DCS(0xC7, 0x68),
		PANEL_DCS(0xC8, 0x02),
		PANEL_DCS(0xC9, 0x60),
		PANEL_DCS(0xCB, 0x64),
		PANEL_DCS(0xD0, 0x64),
		PANEL_DCS(0xD1, 0x00),
		PANEL_DCS(0xD2, 0x00),
		PANEL_DCS(0xD4, 0x64),
		PANEL_DCS(0xD8, 0x05),
		PANEL_DCS(0xD9, 0x64),
		PANEL_DCS(0xDA, 0x00),
		PANEL_DCS(0xDB, 0x00),
		PANEL_DCS(0xDC, 0x05),
		PANEL_DCS(0xDD, 0x64),
		PANEL_DCS(0xDE, 0x00),
		PANEL_DCS(0xDF, 0x00),
		PANEL_DCS(0xE1, 0x05),
		PANEL_DCS(0xE2, 0x64),
		PANEL_DCS(0xE6, 0x02),
		PANEL_DCS(0xE7, 0x68),
		PANEL_DCS(0xE8, 0x02),
		PANEL_DCS(0xE9, 0x60),
		PANEL_DCS(0xEB, 0x64),
		PANEL_DCS(0xF3, 0x02),
		PANEL_DCS(0xF4, 0x68),
		PANEL_DCS(0xF6, 0x02),
		PANEL_DCS(0xF7, 0x60),
		PANEL_DCS(0xF8, 0x66),
		PANEL_DCS(0xF9, 0x66),
		PANEL_DCS(0xFF, 0x23),
		PANEL_DCS(0xFB, 0x01),
		PANEL_DCS(0x6B, 0x1A),
		PANEL_DCS(0x6D, 0x1A),
		PANEL_DCS(0x72, 0x04),
		PANEL_DCS(0x76, 0x07, 0x02),
		PANEL_DCS(0x77, 0x01, 0x02),
		PANEL_DCS(0x78, 0x01, 0x02),
		PANEL_DCS(0x7A, 0x12, 0xF4),
		PANEL_DCS(0x7B, 0x32, 0x32),
		PANEL_DCS(0x7C, 0x2D, 0x32),
		PANEL_DCS(0x7E, 0x11, 0x10),
		PANEL_DCS(0x89, 0xA4),
		PANEL_DCS(0xBA, 0x00, 0x00, 0x21, 0x70, 0x00),
		PANEL_DCS(0xBB, 0x00, 0x00, 0x1F, 0x70, 0x00),
		PANEL_DCS(0xBC, 0xFF, 0x00, 0x01, 0x27, 0x00),
		PANEL_DCS(0xFF, 0x24),
		PANEL_DCS(0xFB, 0x01),
		PANEL_DCS(0x00, 0x03, 0x27, 0x0D, 0x0C, 0x0F, 0x0E, 0x26, 0x26, 0x28, 0x04,
			  0x05, 0x27, 0x26, 0x29, 0x29, 0x08),
		PANEL_DCS(0x01, 0x27, 0x27, 0x30, 0x2E, 0x2C, 0x41, 0x3F, 0x3D),
		PANEL_DCS(0x02, 0x03, 0x27, 0x0D, 0x0C, 0x0F, 0x0E, 0x26, 0x26, 0x28, 0x04,
			  0x05, 0x27, 0x26, 0x29, 0x29, 0x08),
		PANEL_DCS(0x03, 0x27, 0x27, 0x41, 0x3F, 0x3D, 0x30, 0x2E, 0x2C),
		PANEL_DCS(0x09, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x00),
		PANEL_DCS(0x0A, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x00),
		PANEL_DCS(0x0B, 0x26, 0x26, 0x26, 0x26, 0x26, 0x26, 0x00),
		PANEL_DCS(0x0C, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x00),
		PANEL_DCS(0x0D, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x00),
		PANEL_DCS(0x12, 0x21, 0x43, 0x65, 0x87, 0x34, 0x12, 0x56, 0x00),
		PANEL_DCS(0x13, 0x21, 0x43, 0x00, 0x00, 0x00, 0x00, 0x34, 0x12, 0x56, 0x00,
			  0x00, 0x00),
		PANEL_DCS(0x17, 0x41, 0x25, 0x63, 0xA7, 0x8B, 0xC9, 0x0D, 0xE1, 0x2F, 0x63,
			  0x47, 0x85, 0x00, 0x60, 0xFE),
		PANEL_DCS(0x18, 0x41, 0x25, 0x63, 0xA7, 0x8B, 0xC9, 0x0D, 0xE1, 0x2F, 0x63,
			  0x47, 0x85, 0x00, 0x60, 0xFE),
		PANEL_DCS(0x1C, 0x80),
		PANEL_DCS(0x2B, 0x12, 0x01, 0x00, 0x80),
		PANEL_DCS(0x2F, 0x02),
		PANEL_DCS(0x30, 0x01),
		PANEL_DCS(0x31, 0x52),
		PANEL_DCS(0x37, 0x22),
		PANEL_DCS(0x3B, 0x59),
		PANEL_DCS(0x3D, 0x02),
		PANEL_DCS(0x3F, 0x0C),
		PANEL_DCS(0x40, 0x04),
		PANEL_DCS(0x41, 0x52),
		PANEL_DCS(0x47, 0x24),
		PANEL_DCS(0x4B, 0x51),
		PANEL_DCS(0x4C, 0x01),
		PANEL_DCS(0x50, 0x87),
		PANEL_DCS(0x55, 0x0B, 0x03),
		PANEL_DCS(0x56, 0x04),
		PANEL_DCS(0x58, 0x10),
		PANEL_DCS(0x59, 0x10),
		PANEL_DCS(0x5A, 0x03),
		PANEL_DCS(0x5B, 0x55),
		PANEL_DCS(0x5E, 0x00, 0x0B),
		PANEL_DCS(0x60, 0x81, 0xB6),
		PANEL_DCS(0x61, 0x8E),
		PANEL_DCS(0x67, 0x21),
		PANEL_DCS(0x68, 0x43),
		PANEL_DCS(0x71, 0x04),
		PANEL_DCS(0x7E, 0x20),
		PANEL_DCS(0x7F, 0xE1),
		PANEL_DCS(0x92, 0x5C, 0x00, 0xF5, 0x7B),
		PANEL_DCS(0x93, 0x3C, 0x00, 0x42, 0x00, 0x2C, 0x00),
		PANEL_DCS(0x94, 0xBE, 0x00, 0x14, 0x98),
		PANEL_DCS(0x95, 0x09),
		PANEL_DCS(0x96, 0x80, 0xAA, 0x00),
		PANEL_DCS(0x97, 0xC0),
		PANEL_DCS(0x9A, 0x0B),
		PANEL_DCS(0xA4, 0x00, 0x17),
		PANEL_DCS(0xAA, 0xA3, 0xA3, 0x28),
		PANEL_DCS(0xB6, 0x08, 0x08, 0x00),
		PANEL_DCS(0xBC, 0x00, 0x00, 0x43, 0x22),
		PANEL_DCS(0xC2, 0xCC, 0x00, 0x01, 0x00),
		PANEL_DCS(0xD4, 0x03),
		PANEL_DCS(0xD6, 0x46),
		PANEL_DCS(0xD7, 0x25),
		PANEL_DCS(0xD9, 0x21),
		PANEL_DCS(0xDB, 0x34),
		PANEL_DCS(0xDC, 0xA0),
		PANEL_DCS(0xDD, 0x33),
		PANEL_DCS(0xDE, 0x07, 0x00, 0x00, 0x00),
		PANEL_DCS(0xDF, 0x04),
		PANEL_DCS(0xE0, 0xA0),
		PANEL_DCS(0xE1, 0x04),
		PANEL_DCS(0xE2, 0xA0),
		PANEL_DCS(0xE3, 0x04),
		PANEL_DCS(0xE4, 0xA0),
		PANEL_DCS(0xE5, 0x04),
		PANEL_DCS(0xE6, 0xA0),
		PANEL_DCS(0xE7, 0x03),
		PANEL_DCS(0xE9, 0x04),
		PANEL_DCS(0xEA, 0xA0),
		PANEL_DCS(0xEB, 0x04),
		PANEL_DCS(0xEC, 0x81),
		PANEL_DCS(0xEE, 0xA0),
		PANEL_DCS(0xEF, 0x04),
		PANEL_DCS(0xF0, 0xA0),
		PANEL_DCS(0xF1, 0x23),
		PANEL_DCS(0xF2, 0x23),
		PANEL_DCS(0xF3, 0x23),
		PANEL_DCS(0xF4, 0x22),
		PANEL_DCS(0xF5, 0x23),
		PANEL_DCS(0xF6, 0x23),
		PANEL_DCS(0xFF, 0x25),
		PANEL_DCS(0xFB, 0x01),
		PANEL_DCS(0x10, 0x00, 0x02, 0x53, 0x00),
		PANEL_DCS(0x13, 0x01),
		PANEL_DCS(0x14, 0xEB),
		PANEL_DCS(0x15, 0x01),
		PANEL_DCS(0x16, 0xB7),
		PANEL_DCS(0x1F, 0x03),
		PANEL_DCS(0x20, 0x55),
		PANEL_DCS(0x24, 0x12),
		PANEL_DCS(0x26, 0x03),
		PANEL_DCS(0x27, 0x55),
		PANEL_DCS(0x2B, 0x12),
		PANEL_DCS(0x31, 0x20),
		PANEL_DCS(0x33, 0x03),
		PANEL_DCS(0x34, 0x55),
		PANEL_DCS(0x38, 0x12),
		PANEL_DCS(0x39, 0x08),
		PANEL_DCS(0x3A, 0x02),
		PANEL_DCS(0x3F, 0x20),
		PANEL_DCS(0x40, 0x00),
		PANEL_DCS(0x42, 0x0B),
		PANEL_DCS(0x45, 0x59),
		PANEL_DCS(0x47, 0x51),
		PANEL_DCS(0x48, 0x03),
		PANEL_DCS(0x49, 0x55),
		PANEL_DCS(0x4D, 0x12),
		PANEL_DCS(0x4E, 0x08),
		PANEL_DCS(0x50, 0x03),
		PANEL_DCS(0x51, 0x55),
		PANEL_DCS(0x55, 0x12),
		PANEL_DCS(0x56, 0x08),
		PANEL_DCS(0x5B, 0xA0),
		PANEL_DCS(0x5E, 0x59),
		PANEL_DCS(0x60, 0x51),
		PANEL_DCS(0x61, 0x03),
		PANEL_DCS(0x62, 0x55),
		PANEL_DCS(0x66, 0x12),
		PANEL_DCS(0x67, 0x08),
		PANEL_DCS(0x68, 0x0B),
		PANEL_DCS(0x6A, 0x02),
		PANEL_DCS(0x6B, 0x44),
		PANEL_DCS(0x6C, 0x0E),
		PANEL_DCS(0x6E, 0x1A),
		PANEL_DCS(0x7B, 0x58),
		PANEL_DCS(0x7F, 0x58),
		PANEL_DCS(0x83, 0x58),
		PANEL_DCS(0xBC, 0x02),
		PANEL_DCS(0xBD, 0x9E),
		PANEL_DCS(0xC6, 0x10),
		PANEL_DCS(0xDC, 0xD0),
		PANEL_DCS(0xDD, 0x02),
		PANEL_DCS(0xDE, 0x83),
		PANEL_DCS(0xEE, 0x1B),
		PANEL_DCS(0xF6, 0x03),
		PANEL_DCS(0xF7, 0xD6),
		PANEL_DCS(0xF8, 0x0E, 0x00, 0x1A, 0x00),
		PANEL_DCS(0xF9, 0x0E, 0x00, 0x1A, 0x00),
		PANEL_DCS(0xFF, 0x26),
		PANEL_DCS(0xFB, 0x01),
		PANEL_DCS(0x04, 0x68),
		PANEL_DCS(0x06, 0x01, 0x64, 0x1E),
		PANEL_DCS(0x0A, 0x03),
		PANEL_DCS(0x0C, 0x06),
		PANEL_DCS(0x0D, 0x06),
		PANEL_DCS(0x0F, 0x00),
		PANEL_DCS(0x12, 0x51),
		PANEL_DCS(0x13, 0x3A),
		PANEL_DCS(0x14, 0x32),
		PANEL_DCS(0x16, 0x01),
		PANEL_DCS(0x19, 0x20, 0x1F, 0x20, 0x20),
		PANEL_DCS(0x1A, 0xC4, 0xD0, 0xC4, 0xC4),
		PANEL_DCS(0x1B, 0x1E, 0x1D, 0x1E, 0x1E),
		PANEL_DCS(0x1C, 0xD6, 0xEB, 0xD6, 0xD6),
		PANEL_DCS(0x1D, 0x00),
		PANEL_DCS(0x1E, 0x5C),
		PANEL_DCS(0x1F, 0x5C),
		PANEL_DCS(0x24, 0x02),
		PANEL_DCS(0x25, 0x5C),
		PANEL_DCS(0x26, 0x26),
		PANEL_DCS(0x27, 0x22),
		PANEL_DCS(0x28, 0x22),
		PANEL_DCS(0x29, 0x02),
		PANEL_DCS(0x2A, 0x1F, 0x1E, 0x1F, 0x1F),
		PANEL_DCS(0x2B, 0x42, 0x57, 0x42, 0x42),
		PANEL_DCS(0x2F, 0x0B),
		PANEL_DCS(0x30, 0x5C),
		PANEL_DCS(0x32, 0x5C),
		PANEL_DCS(0x33, 0x22),
		PANEL_DCS(0x34, 0x92),
		PANEL_DCS(0x35, 0x78),
		PANEL_DCS(0x36, 0x96),
		PANEL_DCS(0x37, 0x78),
		PANEL_DCS(0x38, 0x16, 0x11, 0x01),
		PANEL_DCS(0x3A, 0x5C),
		PANEL_DCS(0x3D, 0x00, 0x00, 0x2A, 0x20, 0x00, 0x00),
		PANEL_DCS(0x40, 0x57, 0x6E),
		PANEL_DCS(0x41, 0x57),
		PANEL_DCS(0x42, 0x57),
		PANEL_DCS(0x43, 0x02),
		PANEL_DCS(0x44, 0x57),
		PANEL_DCS(0x45, 0x0B),
		PANEL_DCS(0x46, 0x57),
		PANEL_DCS(0x48, 0x57),
		PANEL_DCS(0x4A, 0x57),
		PANEL_DCS(0x4D, 0x02),
		PANEL_DCS(0x4E, 0x54),
		PANEL_DCS(0x4F, 0x02),
		PANEL_DCS(0x50, 0x4C),
		PANEL_DCS(0x51, 0x03),
		PANEL_DCS(0x53, 0x02),
		PANEL_DCS(0x54, 0x72),
		PANEL_DCS(0x56, 0x03),
		PANEL_DCS(0x59, 0x02),
		PANEL_DCS(0x5A, 0x72),
		PANEL_DCS(0x5B, 0x03),
		PANEL_DCS(0x5D, 0x02),
		PANEL_DCS(0x5E, 0x72),
		PANEL_DCS(0x60, 0x03),
		PANEL_DCS(0x61, 0x50),
		PANEL_DCS(0x63, 0x72),
		PANEL_DCS(0x64, 0x03),
		PANEL_DCS(0x65, 0x50),
		PANEL_DCS(0x67, 0x72),
		PANEL_DCS(0x69, 0x03),
		PANEL_DCS(0x6A, 0x50),
		PANEL_DCS(0x6B, 0x02),
		PANEL_DCS(0x6C, 0x72),
		PANEL_DCS(0x6E, 0x02),
		PANEL_DCS(0x6F, 0x54),
		PANEL_DCS(0x70, 0x02),
		PANEL_DCS(0x71, 0x4C),
		PANEL_DCS(0x72, 0x03),
		PANEL_DCS(0x74, 0x02),
		PANEL_DCS(0x75, 0x72),
		PANEL_DCS(0x7B, 0x02),
		PANEL_DCS(0x7C, 0x54),
		PANEL_DCS(0x7E, 0x02),
		PANEL_DCS(0x7F, 0x4C),
		PANEL_DCS(0x80, 0x66),
		PANEL_DCS(0x81, 0x66),
		PANEL_DCS(0x82, 0x00, 0x64, 0x64, 0x64),
		PANEL_DCS(0x84, 0x14, 0x14, 0x14),
		PANEL_DCS(0x85, 0x1A, 0x1A, 0x1A),
		PANEL_DCS(0x8B, 0x74),
		PANEL_DCS(0x8C, 0x08),
		PANEL_DCS(0x8D, 0x00),
		PANEL_DCS(0x8F, 0x00),
		PANEL_DCS(0x91, 0x07),
		PANEL_DCS(0x93, 0xF5),
		PANEL_DCS(0x94, 0xE6),
		PANEL_DCS(0x96, 0x10),
		PANEL_DCS(0x99, 0x10, 0x0F, 0x10, 0x10),
		PANEL_DCS(0x9A, 0xF5, 0x4C, 0xF5, 0xF5),
		PANEL_DCS(0x9B, 0x0F, 0x0E, 0x0F, 0x0F),
		PANEL_DCS(0x9C, 0x7C, 0x3D, 0x7C, 0x7C),
		PANEL_DCS(0x9D, 0x0F, 0x0E, 0x0F, 0x0F),
		PANEL_DCS(0x9E, 0xE8, 0xA9, 0xE8, 0xE8),
		PANEL_DCS(0xA7, 0x01),
		PANEL_DCS(0xC9, 0x1E, 0x00),
		PANEL_DCS(0xCD, 0x1F, 0x97, 0x00),
		PANEL_DCS(0xCE, 0x1D, 0x97, 0x00),
		PANEL_DCS(0xCF, 0xFF, 0x00, 0x00),
		PANEL_DCS(0xD2, 0x2D),
		PANEL_DCS(0xD3, 0x12),
		PANEL_DCS(0xFF, 0x27),
		PANEL_DCS(0xFB, 0x01),
		PANEL_DCS(0x00, 0x80),
		PANEL_DCS(0x01, 0x36),
		PANEL_DCS(0x03, 0x96),
		PANEL_DCS(0x05, 0x04),
		PANEL_DCS(0x06, 0x00),
		PANEL_DCS(0x07, 0x04),
		PANEL_DCS(0x08, 0x6A, 0x06),
		PANEL_DCS(0x09, 0x48, 0x00),
		PANEL_DCS(0x0A, 0x66, 0x00),
		PANEL_DCS(0x0B, 0x30, 0x00),
		PANEL_DCS(0x0C, 0x26, 0x00),
		PANEL_DCS(0x0D, 0x46, 0x00),
		PANEL_DCS(0x0E, 0x66, 0x00),
		PANEL_DCS(0x0F, 0x30, 0x00),
		PANEL_DCS(0x10, 0x26, 0x00),
		PANEL_DCS(0x11, 0x80),
		PANEL_DCS(0x13, 0x06),
		PANEL_DCS(0x31, 0x2A, 0x00),
		PANEL_DCS(0x58, 0x80),
		PANEL_DCS(0x59, 0x00),
		PANEL_DCS(0x5B, 0xB8),
		PANEL_DCS(0x5E, 0x2A),
		PANEL_DCS(0x5F, 0x00),
		PANEL_DCS(0x61, 0x00, 0x00),
		PANEL_DCS(0x63, 0x00, 0x00),
		PANEL_DCS(0x64, 0x00, 0x00),
		PANEL_DCS(0x65, 0x00, 0x00),
		PANEL_DCS(0x67, 0x00, 0x00),
		PANEL_DCS(0x68, 0x00, 0x00),
		PANEL_DCS(0x69, 0x80),
		PANEL_DCS(0x77, 0x2A, 0x00),
		PANEL_DCS(0x78, 0x80),
		PANEL_DCS(0x79, 0xA4),
		PANEL_DCS(0x7A, 0x00),
		PANEL_DCS(0x7B, 0x01),
		PANEL_DCS(0x7D, 0x04),
		PANEL_DCS(0x7E, 0x00),
		PANEL_DCS(0x7F, 0x04),
		PANEL_DCS(0x80, 0x7E, 0x0A),
		PANEL_DCS(0x81, 0x59, 0x00),
		PANEL_DCS(0x82, 0xFE, 0x00),
		PANEL_DCS(0x83, 0x23, 0x00),
		PANEL_DCS(0x84, 0x32, 0x00),
		PANEL_DCS(0x85, 0x56, 0x00),
		PANEL_DCS(0x86, 0xFE, 0x00),
		PANEL_DCS(0x87, 0x23, 0x00),
		PANEL_DCS(0x88, 0x32, 0x00),
		PANEL_DCS(0x89, 0x80),
		PANEL_DCS(0x97, 0x2A, 0x00),
		PANEL_DCS(0xD1, 0x02, 0x00),
		PANEL_DCS(0xFF, 0x2A),
		PANEL_DCS(0xFB, 0x01),
		PANEL_DCS(0x00, 0x13),
		PANEL_DCS(0x01, 0x04),
		PANEL_DCS(0x02, 0x44),
		PANEL_DCS(0x03, 0x04),
		PANEL_DCS(0x04, 0x64),
		PANEL_DCS(0x05, 0x04),
		PANEL_DCS(0x06, 0x64),
		PANEL_DCS(0x08, 0x04),
		PANEL_DCS(0x09, 0x64),
		PANEL_DCS(0x0A, 0x04),
		PANEL_DCS(0x0B, 0x64),
		PANEL_DCS(0x0C, 0x04),
		PANEL_DCS(0x0D, 0x64),
		PANEL_DCS(0x0E, 0x23),
		PANEL_DCS(0x0F, 0x23),
		PANEL_DCS(0x10, 0x23),
		PANEL_DCS(0x11, 0x23),
		PANEL_DCS(0x12, 0x23),
		PANEL_DCS(0x13, 0x23),
		PANEL_DCS(0x16, 0x14),
		PANEL_DCS(0x18, 0x14),
		PANEL_DCS(0x1A, 0x14),
		PANEL_DCS(0x1C, 0x14),
		PANEL_DCS(0x1D, 0x06),
		PANEL_DCS(0x27, 0x5F),
		PANEL_DCS(0x28, 0x78),
		PANEL_DCS(0x2F, 0x44, 0x21, 0x02),
		PANEL_DCS(0x30, 0x03),
		PANEL_DCS(0x32, 0x74),
		PANEL_DCS(0x33, 0x91),
		PANEL_DCS(0x40, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x00, 0x79, 0x79, 0x79,
			  0x79, 0x79, 0x79, 0x00),
		PANEL_DCS(0x41, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x00),
		PANEL_DCS(0x42, 0x26, 0x26, 0x26, 0x26, 0x26, 0x26, 0x00, 0x26, 0x26, 0x26,
			  0x26, 0x26, 0x26, 0x00),
		PANEL_DCS(0x43, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x00),
		PANEL_DCS(0x44, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x00, 0x31, 0x31, 0x31,
			  0x31, 0x31, 0x31, 0x00),
		PANEL_DCS(0x4B, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
			  0xFF, 0x00, 0xFF, 0x00, 0xFF),
		PANEL_DCS(0x59, 0x00, 0x02, 0x00, 0x40),
		PANEL_DCS(0x5C, 0x13),
		PANEL_DCS(0x63, 0x22, 0x72, 0x86, 0x67, 0x78, 0x16, 0x11, 0x01),
		PANEL_DCS(0x64, 0x96),
		PANEL_DCS(0x66, 0x01),
		PANEL_DCS(0x67, 0x9E),
		PANEL_DCS(0x68, 0x00),
		PANEL_DCS(0x69, 0x01),
		PANEL_DCS(0x6A, 0x9E),
		PANEL_DCS(0x6B, 0x00),
		PANEL_DCS(0x6C, 0x01),
		PANEL_DCS(0x7F, 0x96),
		PANEL_DCS(0x81, 0x01),
		PANEL_DCS(0x82, 0x96),
		PANEL_DCS(0x84, 0x01),
		PANEL_DCS(0x88, 0x9E),
		PANEL_DCS(0x89, 0x00),
		PANEL_DCS(0x8A, 0x01),
		PANEL_DCS(0x8B, 0x16),
		PANEL_DCS(0x8C, 0x00),
		PANEL_DCS(0x8D, 0x00),
		PANEL_DCS(0x8E, 0x16),
		PANEL_DCS(0x8F, 0x00),
		PANEL_DCS(0x90, 0x00),
		PANEL_DCS(0x92, 0x00),
		PANEL_DCS(0x93, 0x01),
		PANEL_DCS(0x94, 0x06),
		PANEL_DCS(0x99, 0x91),
		PANEL_DCS(0x9A, 0x05),
		PANEL_DCS(0xA2, 0x3F, 0x00),
		PANEL_DCS(0xA4, 0x0F, 0x00),
		PANEL_DCS(0xA5, 0xC3, 0x00),
		PANEL_DCS(0xA9, 0x21),
		PANEL_DCS(0xB1, 0x00, 0x01),
		PANEL_DCS(0xB3, 0x16, 0x00, 0x00),
		PANEL_DCS(0xB6, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x77, 0x77, 0x00, 0x00, 0x00),
		PANEL_DCS(0xB9, 0xA0, 0x06, 0x40, 0x04, 0x5F, 0x41, 0x89, 0xEC, 0x89, 0xEC,
			  0x55, 0x10, 0x40, 0x80, 0x40, 0x40),
		PANEL_DCS(0xBC, 0x77, 0x07),
		PANEL_DCS(0xC4, 0x22),
		PANEL_DCS(0xC6, 0x12),
		PANEL_DCS(0xC7, 0x73),
		PANEL_DCS(0xC8, 0x08),
		PANEL_DCS(0xCA, 0x01),
		PANEL_DCS(0xCB, 0x11, 0x00, 0x00, 0x00),
		PANEL_DCS(0xCC, 0x11, 0x33, 0x22, 0x44, 0x33, 0x11, 0x22, 0x44, 0x11, 0x33,
			  0x22, 0x44, 0x33, 0x11, 0x22, 0x44),
		PANEL_DCS(0xD0, 0x04),
		PANEL_DCS(0xD1, 0x01),
		PANEL_DCS(0xE4, 0x01),
		PANEL_DCS(0xF4, 0x91),
		PANEL_DCS(0xF5, 0x05),
		PANEL_DCS(0xFF, 0xE0),
		PANEL_DCS(0xFB, 0x01),
		PANEL_DCS(0xBB, 0x00),
		PANEL_DCS(0xFF, 0xF0),
		PANEL_DCS(0xFB, 0x01),
		PANEL_DCS(0xE6, 0x02),
		PANEL_DCS(0xFF, 0x10),
		PANEL_DCS(0xFB, 0x01),
		PANEL_DCS(0x3B, 0x03, 0xBE, 0x3C, 0x04, 0x04, 0x00, 0x80, 0x14, 0x98),
		PANEL_DCS(0x60, 0x00),
		PANEL_DCS(0x90, 0x03, 0x00),
		PANEL_DCS(0x91, 0xAB, 0xA8, 0x00, 0x1E, 0xD2, 0x00, 0x00, 0x00, 0x03, 0x68,
			  0x00, 0x0C, 0x03, 0x97, 0x02, 0x17),
		PANEL_DCS(0x92, 0x10, 0xF0),
		PANEL_DCS(0xB2, 0x91, 0x80),
		PANEL_DCS(0xB3, 0x40),

		PANEL_DCS(0x11),
		PANEL_DELAY(120),

		PANEL_DCS(0x29),
		PANEL_END,
	},
	.dsc_config = {
		.dsc_version_major = 0x1,
		.dsc_version_minor = 0x2,
		.bits_per_component = 0xa,
		.line_buf_depth = 0xb,
		.block_pred_enable = true,
		.convert_rgb = 1,
		.simple_422 = false,
		.bits_per_pixel = 8 << 4,
		.slice_height = 30,
		.slice_width = 876,
		.slice_chunk_size = 876,
		.initial_xmit_delay = 512,
		.initial_dec_delay = 731,
		.initial_scale_value = 32,
		.scale_increment_interval = 872,
		.scale_decrement_interval = 12,
		.first_line_bpg_offset = 13,
		.nfl_bpg_offset = 919,
		.slice_bpg_offset = 535,
		.initial_offset = 6144,
		.final_offset = 4336,
		.flatness_min_qp = 7,
		.flatness_max_qp = 16,
		.rc_model_size = 8192,
		.rc_edge_factor = 6,
		.rc_quant_incr_limit0 = 15,
		.rc_quant_incr_limit1 = 15,
		.rc_tgt_offset_high = 3,
		.rc_tgt_offset_low = 3,
		.rc_buf_thresh = { 14, 28, 42, 56, 70, 84, 98, 105,
				   112, 119, 121, 123, 125, 126 },

		.rc_range_params = {
			[0] = { .range_min_qp = 0,  .range_max_qp = 8,
				 .range_bpg_offset = 2 },
			[1] = { .range_min_qp = 4,  .range_max_qp = 8,
				 .range_bpg_offset = 0 },
			[2] = { .range_min_qp = 5,  .range_max_qp = 9,
				 .range_bpg_offset = 0 },
			[3] = { .range_min_qp = 5,  .range_max_qp = 10,
				 .range_bpg_offset = -2 },
			[4] = { .range_min_qp = 7,  .range_max_qp = 11,
				 .range_bpg_offset = -4 },
			[5] = { .range_min_qp = 7,  .range_max_qp = 11,
				 .range_bpg_offset = -6 },
			[6] = { .range_min_qp = 7,  .range_max_qp = 11,
				 .range_bpg_offset = -8 },
			[7] = { .range_min_qp = 7,  .range_max_qp = 12,
				 .range_bpg_offset = -8 },
			[8] = { .range_min_qp = 7,  .range_max_qp = 13,
				 .range_bpg_offset = -8 },
			[9] = { .range_min_qp = 7,  .range_max_qp = 14,
				 .range_bpg_offset = -10 },
			[10] = { .range_min_qp = 9,  .range_max_qp = 14,
				 .range_bpg_offset = -10 },
			[11] = { .range_min_qp = 9,  .range_max_qp = 15,
				 .range_bpg_offset = -12 },
			[12] = { .range_min_qp = 9,  .range_max_qp = 15,
				 .range_bpg_offset = -12 },
			[13] = { .range_min_qp = 13, .range_max_qp = 16,
				 .range_bpg_offset = -12 },
			[14] = { .range_min_qp = 16, .range_max_qp = 17,
				 .range_bpg_offset = -12 },
		}
	},
};
