# Mainboard-specific documentation

This section contains documentation about coreboot on specific mainboards.

## 51NB

```{toctree}
:maxdepth: 1

X210 <51nb/x210.md>
```

## Acer

```{toctree}
:maxdepth: 1

G43T-AM3 <acer/g43t-am3.md>
```

## AMD
```{toctree}
:maxdepth: 1

pademelon <amd/pademelon/pademelon.md>
```

## ASRock

```{toctree}
:maxdepth: 1

H77 Pro4-M <asrock/h77pro4-m.md>
H81M-HDS <asrock/h81m-hds.md>
H110M-DVS <asrock/h110m-dvs.md>
IMB-1222 <asrock/imb-1222.md>
```

## ASUS

```{toctree}
:maxdepth: 1

A88XM-E <asus/a88xm-e.md>
F2A85-M <asus/f2a85-m.md>
H610i-PLUS D4 <asus/h610i-plus-d4>
P2B-LS <asus/p2b-ls.md>
P3B-F <asus/p3b-f.md>
P5Q <asus/p5q.md>
P8C WS <asus/p8c_ws.md>
P8H61-M LX <asus/p8h61-m_lx.md>
P8H61-M Pro <asus/p8h61-m_pro.md>
P8H77-V <asus/p8h77-v.md>
P8Z77-M <asus/p8z77-m.md>
P8Z77-M Pro <asus/p8z77-m_pro.md>
P8Z77-V <asus/p8z77-v.md>
P8Z77-V LE PLUS <asus/p8z77-v_le_plus.md>
wifigo_v1 <asus/wifigo_v1.md>
```

## Cavium

```{toctree}
:maxdepth: 1

CN81XX EVB SFF <cavium/cn8100_sff_evb.md>
```

## Clevo

```{toctree}
:maxdepth: 1

N130WU / N131WU <clevo/n130wu/index.md>
```

## Dell

```{toctree}
:maxdepth: 1

Latitude E7240 <dell/e7240.md>
OptiPlex 9010 SFF <dell/optiplex_9010.md>
```

## Emulation

The boards in this section are not real mainboards, but emulators.

```{toctree}
:maxdepth: 1

Spike RISC-V emulator <emulation/spike-riscv.md>
QEMU RISC-V emulator <emulation/qemu-riscv.md>
QEMU AArch64 emulator <emulation/qemu-aarch64.md>
QEMU SBSA emulator <emulation/qemu-sbsa.md>
QEMU x86 Q35 <emulation/qemu-q35.md>
QEMU x86 PC <emulation/qemu-i440fx.md>
QEMU POWER9 <emulation/qemu-power9.md>
```

## Erying

```{toctree}
:maxdepth: 1

Polestar G613 Pro <erying/tgl/tgl_matx.md>
```

## Facebook

```{toctree}
:maxdepth: 1

FBG-1701 <facebook/fbg1701.md>
Monolith <facebook/monolith.md>
```

## Foxconn

```{toctree}
:maxdepth: 1

D41S <foxconn/d41s.md>
```

## Gigabyte

```{toctree}
:maxdepth: 1

GA-G41M-ES2L <gigabyte/ga-g41m-es2l.md>
GA-H61M-S2PV <gigabyte/ga-h61m-s2pv.md>
```

## HP

```{toctree}
:maxdepth: 1

Compaq 8200 Elite SFF <hp/compaq_8200_sff.md>
Compaq 8300 Elite SFF <hp/compaq_8300_sff.md>
Compaq Elite 8300 USDT <hp/compaq_8300_usdt.md>
Compaq Pro 6300 Series Microtower/SFF <hp/compaq_pro_6300_series.md>
Pro 3x00 Series <hp/pro_3x00_series.md>
Z220 Workstation SFF <hp/z220_sff.md>
```

### EliteBook series

```{toctree}
:maxdepth: 1

HP Laptops with KBC1126 EC <hp/hp_kbc1126_laptops.md>
HP Sure Start <hp/hp_sure_start.md>
EliteBook 2170p <hp/2170p.md>
EliteBook 2560p <hp/2560p.md>
EliteBook 8560w <hp/8560w.md>
EliteBook 8760w <hp/8760w.md>
EliteBook Folio 9480m <hp/folio_9480m.md>
EliteBook 820 G2 <hp/elitebook_820_g2.md>
```

## Intel

```{toctree}
:maxdepth: 1

DG43GT <intel/dg43gt.md>
DQ67SW <intel/dq67sw.md>
KBLRVP11 <intel/kblrvp11.md>
```

## Kontron

```{toctree}
:maxdepth: 1

mAL-10 <kontron/mal10.md>
```

## Lenovo

```{toctree}
:maxdepth: 1

Mainboard codenames <lenovo/codenames.md>
Hardware Maintenance Manual of ThinkPads <lenovo/thinkpad_hmm.md>
R60 <lenovo/r60.md>
ThinkCentre M710s <lenovo/thinkcentre_m710s.md>
ThinkCentre M700 / M900 Tiny <lenovo/thinkcentre_m900_tiny.md>
T4xx common <lenovo/t4xx_series.md>
X2xx common <lenovo/x2xx_series.md>
M920 Tiny <lenovo/m920q.md>
vboot <lenovo/vboot.md>
```

### GM45 series

```{toctree}
:maxdepth: 1

X200 / T400 / T500 / X301 common <lenovo/montevina_series.md>
X301 <lenovo/x301.md>
```

### Arrandale series

```{toctree}
:maxdepth: 1

T410 <lenovo/t410.md>
```

### Sandy Bridge series

```{toctree}
:maxdepth: 1

T420 <lenovo/t420.md>
T420 / T520 / X220 / T420s / W520 common <lenovo/Sandy_Bridge_series.md>
X1 <lenovo/x1.md>
```

### Ivy Bridge series

```{toctree}
:maxdepth: 1

T430 <lenovo/t430.md>
T530 / W530 <lenovo/w530.md>
T430 / T530 / X230 / W530 common <lenovo/Ivy_Bridge_series.md>
T431s <lenovo/t431s.md>
X230s <lenovo/x230s.md>
Internal flashing <lenovo/ivb_internal_flashing.md>
```

### Haswell series

```{toctree}
:maxdepth: 1

T440p <lenovo/t440p.md>
```

### Skylake/Kabylake series

```{toctree}
:maxdepth: 1

T470s/T480/T480s/T580/X280 <lenovo/skylake.md>
```
## Libretrend

```{toctree}
:maxdepth: 1

LT1000 <libretrend/lt1000.md>
```

## MSI

```{toctree}
:maxdepth: 1

MS-7707 <msi/ms7707/ms7707.md>
```

## OCP

```{toctree}
:maxdepth: 1

Delta Lake <ocp/deltalake.md>
Tioga Pass <ocp/tiogapass.md>
```

## Open Cellular

```{toctree}
:maxdepth: 1

Elgon <opencellular/elgon.md>
```

## PC Engines

```{toctree}
:maxdepth: 1

APU1 <pcengines/apu1.md>
APU2 <pcengines/apu2.md>
```

## Portwell

```{toctree}
:maxdepth: 1

PQ7-M107 <portwell/pq7-m107.md>
```

## Prodrive

```{toctree}
:maxdepth: 1

Hermes <prodrive/hermes.md>
```

## Purism

```{toctree}
:maxdepth: 1

Librem 14 <purism/librem_14.md>
Librem Mini <purism/librem_mini.md>
```

## Protectli

```{toctree}
:maxdepth: 1

FW2B / FW4B <protectli/fw2b_fw4b.md>
FW6A / FW6B / FW6C <protectli/fw6.md>
VP2420 <protectli/vp2420.md>
VP4630 / VP4650 / VP4670 <protectli/vp46xx.md>
```

## Roda

```{toctree}
:maxdepth: 1

RK9 Flash Header <roda/rk9/flash_header.md>
```

## SiFive

```{toctree}
:maxdepth: 1

SiFive HiFive Unleashed <sifive/hifive-unleashed.md>
```

## Star Labs Systems

```{toctree}
:maxdepth: 1

LabTop Mk III <starlabs/labtop_kbl.md>
LabTop Mk IV <starlabs/labtop_cml.md>
StarLite Mk III <starlabs/lite_glk.md>
StarLite Mk IV <starlabs/lite_glkr.md>
StarLite Mk V <starlabs/lite_adl.md>
StarBook Mk V <starlabs/starbook_tgl.md>
StarBook Mk VI <starlabs/starbook_adl.md>
StarBook Mk VII (N200) <starlabs/starbook_adl_n.md>
StarBook Mk VII (165H) <starlabs/starbook_mtl.md>
Byte Mk II <starlabs/byte_adl.md>
StarFighter Mk I <starlabs/starfighter_rpl.md>
StarFighter Mk II <starlabs/starfighter_mtl.md>

Building coreboot <starlabs/common/building.md>
Flashing devices <starlabs/common/flashing.md>
```

## Supermicro

```{toctree}
:maxdepth: 1

X9SAE <supermicro/x9sae.md>
X10SLM+-F <supermicro/x10slm-f.md>
X11 LGA1151 series <supermicro/x11-lga1151-series/x11-lga1151-series.md>
Flashing using the BMC <supermicro/flashing_on_vendorbmc.md>
```

## System76

```{toctree}
:maxdepth: 1

Adder Workstation 1 <system76/addw1.md>
Adder Workstation 2 <system76/addw2.md>
Adder Workstation 3 <system76/addw3.md>
Bonobo Workstation 14 <system76/bonw14.md>
Bonobo Workstation 15 <system76/bonw15.md>
Darter Pro 6 <system76/darp6.md>
Darter Pro 7 <system76/darp7.md>
Darter Pro 8 <system76/darp8.md>
Darter Pro 9 <system76/darp9.md>
Galago Pro 4 <system76/galp4.md>
Galago Pro 5 <system76/galp5.md>
Galago Pro 6 <system76/galp6.md>
Galago Pro 7 <system76/galp7.md>
Gazelle 15 <system76/gaze15.md>
Gazelle 16 <system76/gaze16.md>
Gazelle 17 <system76/gaze17.md>
Gazelle 18 <system76/gaze18.md>
Lemur Pro 9 <system76/lemp9.md>
Lemur Pro 10 <system76/lemp10.md>
Lemur Pro 11 <system76/lemp11.md>
Lemur Pro 12 <system76/lemp12.md>
Oryx Pro 5 <system76/oryp5.md>
Oryx Pro 6 <system76/oryp6.md>
Oryx Pro 7 <system76/oryp7.md>
Oryx Pro 8 <system76/oryp8.md>
Oryx Pro 9 <system76/oryp9.md>
Oryx Pro 10 <system76/oryp10.md>
Oryx Pro 11 <system76/oryp11.md>
Serval Workstation 13 <system76/serw13.md>
```

## Texas Instruments

```{toctree}
:maxdepth: 1

Beaglebone Black <ti/beaglebone-black.md>
```

## Topton
```{toctree}
:maxdepth: 1

X2F-N100 <topton/adl/x2f-n100.md>
```

## UP

```{toctree}
:maxdepth: 1

Squared <up/squared/index.md>
```
