/** @file

Copyright (c) 2024, Intel Corporation. All rights reserved.<BR>

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above copyright notice, this
  list of conditions and the following disclaimer in the documentation and/or
  other materials provided with the distribution.
* Neither the name of Intel Corporation nor the names of its contributors may
  be used to endorse or promote products derived from this software without
  specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
  THE POSSIBILITY OF SUCH DAMAGE.

  This file is automatically generated. Please do NOT modify !!!

**/

#ifndef __FSPSUPD_H__
#define __FSPSUPD_H__

#include <FspUpd.h>

#pragma pack(1)


///
/// Azalia Header structure
///
typedef struct {
  UINT16 VendorId;           ///< Codec Vendor ID
  UINT16 DeviceId;           ///< Codec Device ID
  UINT8  RevisionId;         ///< Revision ID of the codec. 0xFF matches any revision.
  UINT8  SdiNum;             ///< SDI number, 0xFF matches any SDI.
  UINT16 DataDwords;         ///< Number of data DWORDs pointed by the codec data buffer.
  UINT32 Reserved;           ///< Reserved for future use. Must be set to 0.
} AZALIA_HEADER;

///
/// Audio Azalia Verb Table structure
///
typedef struct {
  AZALIA_HEADER Header;      ///< AZALIA PCH header
  UINT32        *Data;       ///< Pointer to the data buffer. Its length is specified in the header
} AUDIO_AZALIA_VERB_TABLE;

///
/// Refer to the definition of PCH_INT_PIN
///
typedef enum {
  SiPchNoInt,        ///< No Interrupt Pin
  SiPchIntA,
  SiPchIntB,
  SiPchIntC,
  SiPchIntD
} SI_PCH_INT_PIN;
///
/// The PCH_DEVICE_INTERRUPT_CONFIG block describes interrupt pin, IRQ and interrupt mode for PCH device.
///
typedef struct {
  UINT8        Device;                  ///< Device number
  UINT8        Function;                ///< Device function
  UINT8        IntX;                    ///< Interrupt pin: INTA-INTD (see SI_PCH_INT_PIN)
  UINT8        Irq;                     ///< IRQ to be set for device.
} SI_PCH_DEVICE_INTERRUPT_CONFIG;

#define SI_PCH_MAX_DEVICE_INTERRUPT_CONFIG  64       ///< Number of all PCH devices


/** Fsp S Configuration
**/
typedef struct {

/** Offset 0x0040 - Logo Pointer
  Points to PEI Display Logo Image
**/
  UINT32                      LogoPtr;

/** Offset 0x0044 - Logo Size
  Size of PEI Display Logo Image
**/
  UINT32                      LogoSize;

/** Offset 0x0048 - Blt Buffer Address
  Address of Blt buffer
**/
  UINT32                      BltBufferAddress;

/** Offset 0x004C - Blt Buffer Size
  Size of Blt Buffer, is equal to PixelWidth * PixelHeight * 4 bytes (the size of
  EFI_GRAPHICS_OUTPUT_BLT_PIXEL)
**/
  UINT32                      BltBufferSize;

/** Offset 0x0050 - Graphics Configuration Ptr
  Points to VBT
**/
  UINT32                      GraphicsConfigPtr;

/** Offset 0x0054 - Enable Device 4
  Enable/disable Device 4
  $EN_DIS
**/
  UINT8                       Device4Enable;

/** Offset 0x0055 - Show SPI controller
  Enable/disable to show SPI controller.
  $EN_DIS
**/
  UINT8                       ShowSpiController;

/** Offset 0x0056
**/
  UINT8                       Rsvd010[2];

/** Offset 0x0058 - MicrocodeRegionBase
  Memory Base of Microcode Updates
**/
  UINT32                      MicrocodeRegionBase;

/** Offset 0x005C - MicrocodeRegionSize
  Size of Microcode Updates
**/
  UINT32                      MicrocodeRegionSize;

/** Offset 0x0060 - Turbo Mode
  Enable/Disable processor Turbo Mode. 0:disable, <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       TurboMode;

/** Offset 0x0061 - Enable SATA SALP Support
  Enable/disable SATA Aggressive Link Power Management.
  $EN_DIS
**/
  UINT8                       SataSalpSupport;

/** Offset 0x0062 - Enable SATA ports
  Enable/disable SATA ports. One byte for each port, byte0 for port0, byte1 for port1,
  and so on.
**/
  UINT8                       SataPortsEnable[8];

/** Offset 0x006A - Enable SATA DEVSLP Feature
  Enable/disable SATA DEVSLP per port. 0 is disable, 1 is enable. One byte for each
  port, byte0 for port0, byte1 for port1, and so on.
**/
  UINT8                       SataPortsDevSlp[8];

/** Offset 0x0072
**/
  UINT8                       Rsvd020[2];

/** Offset 0x0074 - SATA DEVSLP GPIO Pin
  Select SATA DEVSLP Pin. Refer to GPIO_*_MUXING_SATA_DEVSLP_x* for possible values.
**/
  UINT32                      SataPortDevSlpPinMux[8];

/** Offset 0x0094 - Enable USB2 ports
  Enable/disable per USB2 ports. One byte for each port, byte0 for port0, byte1 for
  port1, and so on.
**/
  UINT8                       PortUsb20Enable[16];

/** Offset 0x00A4 - Enable USB2 SW Device Mode
  Enable/disable SW device mode per USB2 ports. One byte for each port, byte0 for
  port0, byte1 for port1, and so on.
**/
  UINT8                       PortUsb20SwDeviceModeEnable[16];

/** Offset 0x00B4 - Enable USB3 ports
  Enable/disable per USB3 ports. One byte for each port, byte0 for port0, byte1 for
  port1, and so on.
**/
  UINT8                       PortUsb30Enable[10];

/** Offset 0x00BE - USB 3.1 Speed Selection
  Choose USB 3.1 Speed Selection per USB3 ports. 1: Gen1, 0: Gen2. One byte for each
  port, byte0 for port0, byte1 for port1, and so on.
  $EN_DIS
**/
  UINT8                       PortUsb31Speed[10];

/** Offset 0x00C8 - Enable xDCI controller
  Enable/disable to xDCI controller.
  $EN_DIS
**/
  UINT8                       XdciEnable;

/** Offset 0x00C9
**/
  UINT8                       Rsvd030;

/** Offset 0x00CA
**/
  UINT8                       UnusedUpdSpace0[2];

/** Offset 0x00CC - Address of PCH_DEVICE_INTERRUPT_CONFIG table.
  The address of the table of PCH_DEVICE_INTERRUPT_CONFIG.
**/
  UINT32                      DevIntConfigPtr;

/** Offset 0x00D0 - Number of DevIntConfig Entry
  Number of Device Interrupt Configuration Entry. If this is not zero, the DevIntConfigPtr
  must not be NULL.
**/
  UINT8                       NumOfDevIntConfig;

/** Offset 0x00D1 - PIRQx to IRQx Map Config
  PIRQx to IRQx mapping. The valid value is 0x00 to 0x0F for each. First byte is for
  PIRQA, second byte is for PIRQB, and so on. The setting is only available in Legacy
  8259 PCI mode.
**/
  UINT8                       PxRcConfig[8];

/** Offset 0x00D9 - Select GPIO IRQ Route
  GPIO IRQ Select. The valid value is 14 or 15.
**/
  UINT8                       GpioIrqRoute;

/** Offset 0x00DA - Select SciIrqSelect
  SCI IRQ Select. The valid value is 9, 10, 11, and 20, 21, 22, 23 for APIC only.
**/
  UINT8                       SciIrqSelect;

/** Offset 0x00DB - Select TcoIrqSelect
  TCO IRQ Select. The valid value is 9, 10, 11, 20, 21, 22, 23.
**/
  UINT8                       TcoIrqSelect;

/** Offset 0x00DC - Enable/Disable Tco IRQ
  Enable/disable TCO IRQ
  $EN_DIS
**/
  UINT8                       TcoIrqEnable;

/** Offset 0x00DD - PCH HDA Verb Table Entry Number
  Number of Entries in Verb Table.
**/
  UINT8                       PchHdaVerbTableEntryNum;

/** Offset 0x00DE
**/
  UINT8                       Rsvd040[2];

/** Offset 0x00E0 - PCH HDA Verb Table Pointer
  Pointer to Array of pointers to Verb Table.
**/
  UINT32                      PchHdaVerbTablePtr;

/** Offset 0x00E4 - PCH HDA Codec Sx Wake Capability
  Capability to detect wake initiated by a codec in Sx
**/
  UINT8                       PchHdaCodecSxWakeCapability;

/** Offset 0x00E5 - Enable SATA
  Enable/disable SATA controller.
  $EN_DIS
**/
  UINT8                       SataEnable;

/** Offset 0x00E6 - SATA Mode
  Select SATA controller working mode.
  0:AHCI, 1:RAID
**/
  UINT8                       SataMode;

/** Offset 0x00E7 - SPIn Device Mode
  Selects SPI operation mode. N represents controller index: SPI0, SPI1, ... Available
  modes: 0:SerialIoSpiDisabled, 1:SerialIoSpiPci, 2:SerialIoSpiHidden
**/
  UINT8                       SerialIoSpiMode[7];

/** Offset 0x00EE - SPI<N> Chip Select Polarity
  Sets polarity for each chip Select. Available options: 0:SerialIoSpiCsActiveLow,
  1:SerialIoSpiCsActiveHigh
**/
  UINT8                       SerialIoSpiCsPolarity[14];

/** Offset 0x00FC - SPI<N> Chip Select Enable
  0:Disabled, 1:Enabled. Enables GPIO for CS0 or CS1 if it is Enabled
**/
  UINT8                       SerialIoSpiCsEnable[14];

/** Offset 0x010A - SPIn Default Chip Select Output
  Sets Default CS as Output. N represents controller index: SPI0, SPI1, ... Available
  options: 0:CS0, 1:CS1
**/
  UINT8                       SerialIoSpiDefaultCsOutput[7];

/** Offset 0x0111 - SPIn Default Chip Select Mode HW/SW
  Sets Default CS Mode Hardware or Software. N represents controller index: SPI0,
  SPI1, ... Available options: 0:HW, 1:SW
**/
  UINT8                       SerialIoSpiCsMode[7];

/** Offset 0x0118 - SPIn Default Chip Select State Low/High
  Sets Default CS State Low or High. N represents controller index: SPI0, SPI1, ...
  Available options: 0:Low, 1:High
**/
  UINT8                       SerialIoSpiCsState[7];

/** Offset 0x011F - SPIn Delayed Rx Clock setting
  00:default, 01:Internal, 10:NegEdge Tx Clock, 11:NegEdge Delayed Rx Clk. Configure
  Delayed Rx Clock
**/
  UINT8                       SerialIoSpiDelayRxClk[7];

/** Offset 0x0126
**/
  UINT8                       Rsvd050[1];

/** Offset 0x0127
**/
  UINT8                       UnusedUpdSpace1[1];

/** Offset 0x0128 - Serial IO SPI CS Pin Muxing
  Select SerialIo SPI CS pin muxing. Refer to GPIO_*_MUXING_SERIALIO_SPIx_CS* for
  possible values.
**/
  UINT32                      SerialIoSpiCsPinMux[14];

/** Offset 0x0160 - Serial IO SPI CLK Pin Muxing
  Select SerialIo SPI CS pin muxing. Refer to GPIO_*_MUXING_SERIALIO_SPIx_CLK* for
  possible values.
**/
  UINT32                      SerialIoSpiClkPinMux[7];

/** Offset 0x017C - Serial IO SPI MISO Pin Muxing
  Select SerialIo SPI MISO pin muxing. Refer to GPIO_*_MUXING_SERIALIO_SPIx_MISO*
  for possible values.
**/
  UINT32                      SerialIoSpiMisoPinMux[7];

/** Offset 0x0198 - Serial IO SPI MOSI Pin Muxing
  Select SerialIo SPI MOSI pin muxing. Refer to GPIO_*_MUXING_SERIALIO_SPIx_MOSI*
  for possible values.
**/
  UINT32                      SerialIoSpiMosiPinMux[7];

/** Offset 0x01B4 - UARTn Device Mode
  Selects Uart operation mode. N represents controller index: Uart0, Uart1, ... Available
  modes: 0:SerialIoUartDisabled, 1:SerialIoUartPci, 2:SerialIoUartHidden, 3:SerialIoUartCom,
  4:SerialIoUartSkipInit
**/
  UINT8                       SerialIoUartMode[7];

/** Offset 0x01BB
**/
  UINT8                       Rsvd060[1];

/** Offset 0x01BC - Default BaudRate for each Serial IO UART
  Set default BaudRate Supported from 0 - default to 6000000
**/
  UINT32                      SerialIoUartBaudRate[7];

/** Offset 0x01D8 - Default ParityType for each Serial IO UART
  Set default Parity. 0: DefaultParity, 1: NoParity, 2: EvenParity, 3: OddParity
**/
  UINT8                       SerialIoUartParity[7];

/** Offset 0x01DF - Default DataBits for each Serial IO UART
  Set default word length. 0: Default, 5,6,7,8
**/
  UINT8                       SerialIoUartDataBits[7];

/** Offset 0x01E6 - Default StopBits for each Serial IO UART
  Set default stop bits. 0: DefaultStopBits, 1: OneStopBit, 2: OneFiveStopBits, 3:
  TwoStopBits
**/
  UINT8                       SerialIoUartStopBits[7];

/** Offset 0x01ED - Power Gating mode for each Serial IO UART that works in COM mode
  Set Power Gating. 0: Disabled, 1: Enabled, 2: Auto
**/
  UINT8                       SerialIoUartPowerGating[7];

/** Offset 0x01F4 - Enable Dma for each Serial IO UART that supports it
  Set DMA/PIO mode. 0: Disabled, 1: Enabled
**/
  UINT8                       SerialIoUartDmaEnable[7];

/** Offset 0x01FB - Enables UART hardware flow control, CTS and RTS lines
  Enables UART hardware flow control, CTS and RTS lines.
**/
  UINT8                       SerialIoUartAutoFlow[7];

/** Offset 0x0202
**/
  UINT8                       Rsvd070[2];

/** Offset 0x0204 - SerialIoUartRtsPinMuxPolicy
  Select SerialIo Uart Rts pin muxing. Refer to GPIO_*_MUXING_SERIALIO_UARTx_RTS*
  for possible values.
**/
  UINT32                      SerialIoUartRtsPinMuxPolicy[7];

/** Offset 0x0220 - SerialIoUartCtsPinMuxPolicy
  Select SerialIo Uart Cts pin muxing. Refer to GPIO_*_MUXING_SERIALIO_UARTx_CTS*
  for possible values.
**/
  UINT32                      SerialIoUartCtsPinMuxPolicy[7];

/** Offset 0x023C - SerialIoUartRxPinMuxPolicy
  Select SerialIo Uart Rx pin muxing. Refer to GPIO_*_MUXING_SERIALIO_UARTx_RX* for
  possible values.
**/
  UINT32                      SerialIoUartRxPinMuxPolicy[7];

/** Offset 0x0258 - SerialIoUartTxPinMuxPolicy
  Select SerialIo Uart Tx pin muxing. Refer to GPIO_*_MUXING_SERIALIO_UARTx_TX* for
  possible values.
**/
  UINT32                      SerialIoUartTxPinMuxPolicy[7];

/** Offset 0x0274 - Serial IO UART DBG2 table
  Enable or disable Serial Io UART DBG2 table, default is Disable; <b>0: Disable;</b>
  1: Enable.
**/
  UINT8                       SerialIoUartDbg2[7];

/** Offset 0x027B - I2Cn Device Mode
  Selects I2c operation mode. N represents controller index: I2c0, I2c1, ... Available
  modes: 0:SerialIoI2cDisabled, 1:SerialIoI2cPci, 2:SerialIoI2cHidden
**/
  UINT8                       SerialIoI2cMode[8];

/** Offset 0x0283
**/
  UINT8                       Rsvd080[1];

/** Offset 0x0284 - Serial IO I2C SDA Pin Muxing
  Select SerialIo I2c Sda pin muxing. Refer to GPIO_*_MUXING_SERIALIO_I2Cx_SDA* for
  possible values.
**/
  UINT32                      PchSerialIoI2cSdaPinMux[8];

/** Offset 0x02A4 - Serial IO I2C SCL Pin Muxing
  Select SerialIo I2c Scl pin muxing. Refer to GPIO_*_MUXING_SERIALIO_I2Cx_SCL* for
  possible values.
**/
  UINT32                      PchSerialIoI2cSclPinMux[8];

/** Offset 0x02C4 - PCH SerialIo I2C Pads Termination
  0x0: Hardware default, 0x1: None, 0x13: 1kOhm weak pull-up, 0x15: 5kOhm weak pull-up,
  0x19: 20kOhm weak pull-up - Enable/disable SerialIo I2C0,I2C1,... pads termination
  respectively. One byte for each controller, byte0 for I2C0, byte1 for I2C1, and so on.
**/
  UINT8                       PchSerialIoI2cPadsTermination[8];

/** Offset 0x02CC - I3C Device Mode
  Selects I3c operation mode. Available modes: 0:SerialIoI3cDisabled, 1:SerialIoI3cPci,
  2:SerialIoI3cPhantom (only applicable to I3C1, controlls GPIO enabling)
**/
  UINT8                       SerialIoI3cMode[2];

/** Offset 0x02CE
**/
  UINT8                       Rsvd090[2];

/** Offset 0x02D0 - Serial IO I3C SDA Pin Muxing
  Select SerialIo I3c Sda pin muxing. Refer to GPIO_*_MUXING_SERIALIO_I3Cx_SDA* for
  possible values.
**/
  UINT32                      SerialIoI3cSdaPinMux[2];

/** Offset 0x02D8 - Serial IO I3C SDA Pad Termination
  0x0: Hardware default, 0x1: None, 0x13: 1kOhm weak pull-up, 0x15: 5kOhm weak pull-up,
  0x19: 20kOhm weak pull-up - Enable/disable SerialIo I3C0,I3C1,... pads termination
  respectively. One byte for each controller, byte0 for I3C0, byte1 for I3C1, and so on.
**/
  UINT8                       SerialIoI3cSdaPadTermination[2];

/** Offset 0x02DA
**/
  UINT8                       Rsvd100[2];

/** Offset 0x02DC - Serial IO I3C SCL Pin Muxing
  Select SerialIo I3c Scl pin muxing. Refer to GPIO_*_MUXING_SERIALIO_I3Cx_SCL* for
  possible values.
**/
  UINT32                      SerialIoI3cSclPinMux[2];

/** Offset 0x02E4 - Serial IO I3C SCL Pad Termination
  0x0: Hardware default, 0x1: None, 0x13: 1kOhm weak pull-up, 0x15: 5kOhm weak pull-up,
  0x19: 20kOhm weak pull-up - Enable/disable SerialIo I3C0,I3C1,... pads termination
  respectively. One byte for each controller, byte0 for I3C0, byte1 for I3C1, and so on.
**/
  UINT8                       SerialIoI3cSclPadTermination[2];

/** Offset 0x02E6
**/
  UINT8                       Rsvd110[2];

/** Offset 0x02E8 - Serial IO I3C SCL FB Pin Muxing
  Select SerialIo I3c SclFb pin muxing. Refer to GPIO_*_MUXING_SERIALIO_I3Cx_SCL FB*
  for possible values.
**/
  UINT32                      SerialIoI3cSclFbPinMux[2];

/** Offset 0x02F0 - Serial IO I3C SCL FB Pad Termination
  0x0: Hardware default, 0x1: None, 0x13: 1kOhm weak pull-up, 0x15: 5kOhm weak pull-up,
  0x19: 20kOhm weak pull-up - Enable/disable SerialIo I3C0,I3C1,... pads termination
  respectively. One byte for each controller, byte0 for I3C0, byte1 for I3C1, and so on.
**/
  UINT8                       SerialIoI3cSclFbPadTermination[2];

/** Offset 0x02F2
**/
  UINT8                       Rsvd120[2];

/** Offset 0x02F4 - ISH GP GPIO Pin Muxing
  Determines ISH GP GPIO Pin muxing. See GPIO_*_MUXING_ISH_GP_x_GPIO_*. 'x' are GP_NUMBER
**/
  UINT32                      IshGpGpioPinMuxing[12];

/** Offset 0x0324 - ISH UART Rx Pin Muxing
  Determines ISH UART Rx Pin muxing. See GPIO_*_MUXING_ISH_UARTx_TXD_*
**/
  UINT32                      IshUartRxPinMuxing[3];

/** Offset 0x0330 - ISH UART Tx Pin Muxing
  Determines ISH UART Tx Pin muxing. See GPIO_*_MUXING_ISH_UARTx_RXD_*
**/
  UINT32                      IshUartTxPinMuxing[3];

/** Offset 0x033C - ISH UART Rts Pin Muxing
  Select ISH UART Rts Pin muxing. Refer to GPIO_*_MUXING_ISH_UARTx_RTS_* for possible values.
**/
  UINT32                      IshUartRtsPinMuxing[3];

/** Offset 0x0348 - ISH UART Rts Pin Muxing
  Select ISH UART Cts Pin muxing. Refer to GPIO_*_MUXING_ISH_UARTx_CTS_* for possible values.
**/
  UINT32                      IshUartCtsPinMuxing[3];

/** Offset 0x0354 - ISH I2C SDA Pin Muxing
  Select ISH I2C SDA Pin muxing. Refer to GPIO_*_MUXING_ISH_I2Cx_SDA_* for possible values.
**/
  UINT32                      IshI2cSdaPinMuxing[3];

/** Offset 0x0360 - ISH I2C SCL Pin Muxing
  Select ISH I2C SCL Pin muxing. Refer to GPIO_*_MUXING_ISH_I2Cx_SCL_* for possible values.
**/
  UINT32                      IshI2cSclPinMuxing[3];

/** Offset 0x036C - ISH I3C SDA Pin Muxing
  Select ISH I3C SDA Pin muxing. Refer to GPIO_*_MUXING_ISH_I3Cx_SDA_* for possible values.
**/
  UINT32                      IshI3cSdaPinMuxing;

/** Offset 0x0370 - ISH I3C SCL Pin Muxing
  Select ISH I3C SCL Pin muxing. Refer to GPIO_*_MUXING_ISH_I3Cx_SCL_* for possible values.
**/
  UINT32                      IshI3cSclPinMuxing;

/** Offset 0x0374 - ISH SPI MOSI Pin Muxing
  Select ISH SPI MOSI Pin muxing. Refer to GPIO_*_MUXING_ISH_SPIx_MOSI_* for possible values.
**/
  UINT32                      IshSpiMosiPinMuxing[2];

/** Offset 0x037C - ISH SPI MISO Pin Muxing
  Select ISH SPI MISO Pin muxing. Refer to GPIO_*_MUXING_ISH_SPIx_MISO_* for possible values.
**/
  UINT32                      IshSpiMisoPinMuxing[2];

/** Offset 0x0384 - ISH SPI CLK Pin Muxing
  Select ISH SPI CLK Pin muxing. Refer to GPIO_*_MUXING_ISH_SPIx_CLK_* for possible values.
**/
  UINT32                      IshSpiClkPinMuxing[2];

/** Offset 0x038C - ISH SPI CS#N Pin Muxing
  Select ISH SPI CS#N Pin muxing. Refer to GPIO_*_MUXING_ISH_SPIx_CS<N>_* for possible
  values. N-SPI number, 0-1.
**/
  UINT32                      IshSpiCsPinMuxing[4];

/** Offset 0x039C - ISH GP GPIO Pad termination
  0x0: Hardware default, 0x1: None, 0x13: 1kOhm weak pull-up, 0x15: 5kOhm weak pull-up,
  0x19: 20kOhm weak pull-up - Enable/disable SerialIo GP#N GPIO pads termination
  respectively. #N are GP_NUMBER, not strictly relate to indexes of this table. Index
  0-23 -> ISH_GP_0-23, Index 24-25 -> ISH_GP_30-31
**/
  UINT8                       IshGpGpioPadTermination[12];

/** Offset 0x03A8 - ISH UART Rx Pad termination
  0x0: Hardware default, 0x1: None, 0x13: 1kOhm weak pull-up, 0x15: 5kOhm weak pull-up,
  0x19: 20kOhm weak pull-up - Enable/disable SerialIo UART#N Rx pads termination
  respectively. #N-byte for each controller, byte0 for UART0 Rx, byte1 for UART1
  Rx, and so on.
**/
  UINT8                       IshUartRxPadTermination[3];

/** Offset 0x03AB - ISH UART Tx Pad termination
  0x0: Hardware default, 0x1: None, 0x13: 1kOhm weak pull-up, 0x15: 5kOhm weak pull-up,
  0x19: 20kOhm weak pull-up - Enable/disable SerialIo UART#N Tx pads termination
  respectively. #N-byte for each controller, byte0 for UART0 Tx, byte1 for UART1
  Tx, and so on.
**/
  UINT8                       IshUartTxPadTermination[3];

/** Offset 0x03AE - ISH UART Rts Pad termination
  0x0: Hardware default, 0x1: None, 0x13: 1kOhm weak pull-up, 0x15: 5kOhm weak pull-up,
  0x19: 20kOhm weak pull-up - Enable/disable SerialIo UART#N Rts pads termination
  respectively. #N-byte for each controller, byte0 for UART0 Rts, byte1 for UART1
  Rts, and so on.
**/
  UINT8                       IshUartRtsPadTermination[3];

/** Offset 0x03B1 - ISH UART Rts Pad termination
  0x0: Hardware default, 0x1: None, 0x13: 1kOhm weak pull-up, 0x15: 5kOhm weak pull-up,
  0x19: 20kOhm weak pull-up - Enable/disable SerialIo UART#N Cts pads termination
  respectively. #N-byte for each controller, byte0 for UART0 Cts, byte1 for UART1
  Cts, and so on.
**/
  UINT8                       IshUartCtsPadTermination[3];

/** Offset 0x03B4 - ISH I2C SDA Pad termination
  0x0: Hardware default, 0x1: None, 0x13: 1kOhm weak pull-up, 0x15: 5kOhm weak pull-up,
  0x19: 20kOhm weak pull-up - Enable/disable SerialIo I2C#N Sda pads termination
  respectively. #N-byte for each controller, byte0 for I2C0 Sda, byte1 for I2C1 Sda,
  and so on.
**/
  UINT8                       IshI2cSdaPadTermination[3];

/** Offset 0x03B7 - ISH I3C SDA Pad termination
  0x0: Hardware default, 0x1: None, 0x13: 1kOhm weak pull-up, 0x15: 5kOhm weak pull-up,
  0x19: 20kOhm weak pull-up - Enable/disable SerialIo I2C#N Sda pads termination
  respectively. #N-byte for each controller, byte0 for I2C0 Sda, byte1 for I2C1 Sda,
  and so on.
**/
  UINT8                       IshI3cSdaPadTermination;

/** Offset 0x03B8 - ISH I2C SCL Pad termination
  0x0: Hardware default, 0x1: None, 0x13: 1kOhm weak pull-up, 0x15: 5kOhm weak pull-up,
  0x19: 20kOhm weak pull-up - Enable/disable SerialIo I2C#N Scl pads termination
  respectively. #N-byte for each controller, byte0 for I2C0 Scl, byte1 for I2C1 Scl,
  and so on.
**/
  UINT8                       IshI2cSclPadTermination[3];

/** Offset 0x03BB - ISH I3C SCL Pad termination
  0x0: Hardware default, 0x1: None, 0x13: 1kOhm weak pull-up, 0x15: 5kOhm weak pull-up,
  0x19: 20kOhm weak pull-up - Enable/disable SerialIo I2C#N Scl pads termination
  respectively. #N-byte for each controller, byte0 for I2C0 Scl, byte1 for I2C1 Scl,
  and so on.
**/
  UINT8                       IshI3cSclPadTermination;

/** Offset 0x03BC - ISH SPI MOSI Pad termination
  0x0: Hardware default, 0x1: None, 0x13: 1kOhm weak pull-up, 0x15: 5kOhm weak pull-up,
  0x19: 20kOhm weak pull-up - Enable/disable SerialIo SPI#N Mosi pads termination
  respectively. #N-byte for each controller, byte0 for SPI0 Mosi, byte1 for SPI1
  Mosi, and so on.
**/
  UINT8                       IshSpiMosiPadTermination[2];

/** Offset 0x03BE - ISH SPI MISO Pad termination
  0x0: Hardware default, 0x1: None, 0x13: 1kOhm weak pull-up, 0x15: 5kOhm weak pull-up,
  0x19: 20kOhm weak pull-up - Enable/disable SerialIo SPI#N Miso pads termination
  respectively. #N-byte for each controller, byte0 for SPI0 Miso, byte1 for SPI1
  Miso, and so on.
**/
  UINT8                       IshSpiMisoPadTermination[2];

/** Offset 0x03C0 - ISH SPI CLK Pad termination
  0x0: Hardware default, 0x1: None, 0x13: 1kOhm weak pull-up, 0x15: 5kOhm weak pull-up,
  0x19: 20kOhm weak pull-up - Enable/disable SerialIo SPI#N Clk pads termination
  respectively. #N-byte for each controller, byte0 for SPI0 Clk, byte1 for SPI1 Clk,
  and so on.
**/
  UINT8                       IshSpiClkPadTermination[2];

/** Offset 0x03C2 - ISH SPI CS#N Pad termination
  0x0: Hardware default, 0x1: None, 0x13: 1kOhm weak pull-up, 0x15: 5kOhm weak pull-up,
  0x19: 20kOhm weak pull-up - Enable/disable SerialIo SPI#N Cs#M pads termination
  respectively. N*M-byte for each controller, byte0 for SPI0 Cs0, byte1 for SPI1
  Cs1, SPI1 Cs0, byte2, SPI1 Cs1, byte3
**/
  UINT8                       IshSpiCsPadTermination[4];

/** Offset 0x03C6 - Enable PCH ISH SPI Cs#N pins assigned
  Set if ISH SPI Cs#N pins are to be enabled by BIOS. 0: Disable; 1: Enable. N-Cs
  number: 0-1
**/
  UINT8                       PchIshSpiCsEnable[4];

/** Offset 0x03CA - USB Per Port HS Preemphasis Bias
  USB Per Port HS Preemphasis Bias. 000b-0mV, 001b-11.25mV, 010b-16.9mV, 011b-28.15mV,
  100b-28.15mV, 101b-39.35mV, 110b-45mV, 111b-56.3mV. One byte for each port.
**/
  UINT8                       Usb2PhyPetxiset[16];

/** Offset 0x03DA - USB Per Port HS Transmitter Bias
  USB Per Port HS Transmitter Bias. 000b-0mV, 001b-11.25mV, 010b-16.9mV, 011b-28.15mV,
  100b-28.15mV, 101b-39.35mV, 110b-45mV, 111b-56.3mV, One byte for each port.
**/
  UINT8                       Usb2PhyTxiset[16];

/** Offset 0x03EA - USB Per Port HS Transmitter Emphasis
  USB Per Port HS Transmitter Emphasis. 00b - Emphasis OFF, 01b - De-emphasis ON,
  10b - Pre-emphasis ON, 11b - Pre-emphasis & De-emphasis ON. One byte for each port.
**/
  UINT8                       Usb2PhyPredeemp[16];

/** Offset 0x03FA - USB Per Port Half Bit Pre-emphasis
  USB Per Port Half Bit Pre-emphasis. 1b - half-bit pre-emphasis, 0b - full-bit pre-emphasis.
  One byte for each port.
**/
  UINT8                       Usb2PhyPehalfbit[16];

/** Offset 0x040A - Enable the write to USB 3.0 TX Output -3.5dB De-Emphasis Adjustment
  Enable the write to USB 3.0 TX Output -3.5dB De-Emphasis Adjustment. Each value
  in arrary can be between 0-1. One byte for each port.
**/
  UINT8                       Usb3HsioTxDeEmphEnable[10];

/** Offset 0x0414 - USB 3.0 TX Output -3.5dB De-Emphasis Adjustment Setting
  USB 3.0 TX Output -3.5dB De-Emphasis Adjustment Setting, HSIO_TX_DWORD5[21:16],
  <b>Default = 29h</b> (approximately -3.5dB De-Emphasis). One byte for each port.
**/
  UINT8                       Usb3HsioTxDeEmph[10];

/** Offset 0x041E - Enable the write to USB 3.0 TX Output Downscale Amplitude Adjustment
  Enable the write to USB 3.0 TX Output Downscale Amplitude Adjustment, Each value
  in arrary can be between 0-1. One byte for each port.
**/
  UINT8                       Usb3HsioTxDownscaleAmpEnable[10];

/** Offset 0x0428 - USB 3.0 TX Output Downscale Amplitude Adjustment
  USB 3.0 TX Output Downscale Amplitude Adjustment, HSIO_TX_DWORD8[21:16], <b>Default
  = 00h</b>. One byte for each port.
**/
  UINT8                       Usb3HsioTxDownscaleAmp[10];

/** Offset 0x0432
**/
  UINT8                       PchUsb3HsioCtrlAdaptOffsetCfgEnable[10];

/** Offset 0x043C
**/
  UINT8                       PchUsb3HsioFilterSelNEnable[10];

/** Offset 0x0446
**/
  UINT8                       PchUsb3HsioFilterSelPEnable[10];

/** Offset 0x0450
**/
  UINT8                       PchUsb3HsioOlfpsCfgPullUpDwnResEnable[10];

/** Offset 0x045A
**/
  UINT8                       PchUsb3HsioCtrlAdaptOffsetCfg[10];

/** Offset 0x0464
**/
  UINT8                       PchUsb3HsioOlfpsCfgPullUpDwnRes[10];

/** Offset 0x046E
**/
  UINT8                       PchUsb3HsioFilterSelN[10];

/** Offset 0x0478
**/
  UINT8                       PchUsb3HsioFilterSelP[10];

/** Offset 0x0482 - Enable LAN
  Enable/disable LAN controller.
  $EN_DIS
**/
  UINT8                       PchLanEnable;

/** Offset 0x0483 - Enable PCH TSN
  Enable/disable TSN on the PCH.
  $EN_DIS
**/
  UINT8                       PchTsnEnable;

/** Offset 0x0484 - TSN Link Speed
  Set TSN Link Speed.
  0: 24Mhz 2.5Gbps, 1: 24Mhz 1Gbps, 2: 38.4Mhz 2.5Gbps, 3: 38.4Mhz 1Gbps
**/
  UINT8                       PchTsnLinkSpeed;

/** Offset 0x0485
**/
  UINT8                       Rsvd130[3];

/** Offset 0x0488 - PCH TSN MAC Address High Bits
  Set TSN MAC Address High.
**/
  UINT32                      PchTsnMacAddressHigh;

/** Offset 0x048C - PCH TSN MAC Address Low Bits
  Set TSN MAC Address Low.
**/
  UINT32                      PchTsnMacAddressLow;

/** Offset 0x0490 - PCH TSN MAC Address High Bits
  Set TSN MAC Address High.
**/
  UINT32                      PchTsn1MacAddressHigh;

/** Offset 0x0494 - PCH TSN MAC Address Low Bits
  Set TSN MAC Address Low.
**/
  UINT32                      PchTsn1MacAddressLow;

/** Offset 0x0498 - PCIe PTM enable/disable
  Enable/disable Precision Time Measurement for PCIE Root Ports.
**/
  UINT8                       PciePtm[29];

/** Offset 0x04B5 - Disable DMI Power Gating
  Enable/disable DMI Power Gating Disable.
  $EN_DIS
**/
  UINT8                       DmiPowerGatingDis;

/** Offset 0x04B6
**/
  UINT8                       Rsvd135[28];

/** Offset 0x04D2 - USB PDO Programming
  Enable/disable PDO programming for USB in PEI phase. Disabling will allow for programming
  during later phase. 1: enable, 0: disable
  $EN_DIS
**/
  UINT8                       UsbPdoProgramming;

/** Offset 0x04D3
**/
  UINT8                       Rsvd140[5];

/** Offset 0x04D8 - Power button debounce configuration
  Debounce time for PWRBTN in microseconds. For values not supported by HW, they will
  be rounded down to closest supported on. 0: disable, 250-1024000us: supported range
**/
  UINT32                      PmcPowerButtonDebounce;

/** Offset 0x04DC - PCH eSPI Host and Device BME enabled
  PCH eSPI Host and Device BME enabled
  $EN_DIS
**/
  UINT8                       PchEspiBmeHostDeviceEnabled;

/** Offset 0x04DD - PCH eSPI Link Configuration Lock (SBLCL)
  Enable/Disable lock of communication through SET_CONFIG/GET_CONFIG to eSPI target
  addresseses from range 0x0 - 0x7FF
  $EN_DIS
**/
  UINT8                       PchEspiLockLinkConfiguration;

/** Offset 0x04DE - Mask to enable the usage of external V1p05 VR rail in specific S0ix or Sx states
  Enable External V1P05 Rail in: BIT0:S0i1/S0i2, BIT1:S0i3, BIT2:S3, BIT3:S4, BIT5:S5
**/
  UINT8                       PchFivrExtV1p05RailEnabledStates;

/** Offset 0x04DF - Mask to enable the platform configuration of external V1p05 VR rail
  External V1P05 Rail Supported Configuration
**/
  UINT8                       PchFivrExtV1p05RailSupportedVoltageStates;

/** Offset 0x04E0 - External V1P05 Voltage Value that will be used in S0i2/S0i3 states
  Value is given in 2.5mV increments (0=0mV, 1=2.5mV, 2=5mV...)
**/
  UINT16                      PchFivrExtV1p05RailVoltage;

/** Offset 0x04E2 - External V1P05 Icc Max Value
  Granularity of this setting is 1mA and maximal possible value is 200mA
**/
  UINT8                       PchFivrExtV1p05RailIccMax;

/** Offset 0x04E3 - Mask to enable the usage of external Vnn VR rail in specific S0ix or Sx states
  Enable External Vnn Rail in: BIT0:S0i1/S0i2, BIT1:S0i3, BIT2:S3, BIT3:S4, BIT5:S5
**/
  UINT8                       PchFivrExtVnnRailEnabledStates;

/** Offset 0x04E4 - Mask to enable the platform configuration of external Vnn VR rail
  External Vnn Rail Supported Configuration
**/
  UINT8                       PchFivrExtVnnRailSupportedVoltageStates;

/** Offset 0x04E5
**/
  UINT8                       Rsvd150;

/** Offset 0x04E6 - External Vnn Voltage Value that will be used in S0ix/Sx states
  Value is given in 2.5mV increments (0=0mV, 1=2.5mV, 2=5mV...), Default is set to 420
**/
  UINT16                      PchFivrExtVnnRailVoltage;

/** Offset 0x04E8 - External Vnn Icc Max Value that will be used in S0ix/Sx states
  Granularity of this setting is 1mA and maximal possible value is 200mA
**/
  UINT8                       PchFivrExtVnnRailIccMax;

/** Offset 0x04E9 - Mask to enable the usage of external Vnn VR rail in Sx states
  Use only if Ext Vnn Rail config is different in Sx. Enable External Vnn Rail in
  Sx: BIT0-1:Reserved, BIT2:S3, BIT3:S4, BIT5:S5
**/
  UINT8                       PchFivrExtVnnRailSxEnabledStates;

/** Offset 0x04EA - External Vnn Voltage Value that will be used in Sx states
  Use only if Ext Vnn Rail config is different in Sx. Value is given in 2.5mV increments
  (0=0mV, 1=2.5mV, 2=5mV...)
**/
  UINT16                      PchFivrExtVnnRailSxVoltage;

/** Offset 0x04EC - External Vnn Icc Max Value that will be used in Sx states
  Use only if Ext Vnn Rail config is different in Sx. Granularity of this setting
  is 1mA and maximal possible value is 200mA
**/
  UINT8                       PchFivrExtVnnRailSxIccMax;

/** Offset 0x04ED - Transition time in microseconds from Low Current Mode Voltage to High Current Mode Voltage
  This field has 1us resolution. When value is 0 PCH will not transition VCCIN_AUX
  to low current mode voltage.
**/
  UINT8                       PchFivrVccinAuxLowToHighCurModeVolTranTime;

/** Offset 0x04EE - Transition time in microseconds from Retention Mode Voltage to High Current Mode Voltage
  This field has 1us resolution. When value is 0 PCH will not transition VCCIN_AUX
  to retention mode voltage.
**/
  UINT8                       PchFivrVccinAuxRetToHighCurModeVolTranTime;

/** Offset 0x04EF - Transition time in microseconds from Retention Mode Voltage to Low Current Mode Voltage
  This field has 1us resolution. When value is 0 PCH will not transition VCCIN_AUX
  to retention mode voltage.
**/
  UINT8                       PchFivrVccinAuxRetToLowCurModeVolTranTime;

/** Offset 0x04F0 - Transition time in microseconds from Off (0V) to High Current Mode Voltage
  This field has 1us resolution. When value is 0 Transition to 0V is disabled.
**/
  UINT16                      PchFivrVccinAuxOffToHighCurModeVolTranTime;

/** Offset 0x04F2 - PMC Debug Message Enable
  When Enabled, PMC HW will send debug messages to trace hub; When Disabled, PMC HW
  will never send debug meesages to trace hub. Noted: When Enabled, may not enter S0ix
  $EN_DIS
**/
  UINT8                       PmcDbgMsgEn;

/** Offset 0x04F3
**/
  UINT8                       Rsvd160;

/** Offset 0x04F4 - Pointer to ChipsetInit Binary
  ChipsetInit Binary Pointer.
**/
  UINT32                      ChipsetInitBinPtr;

/** Offset 0x04F8 - Length of ChipsetInit Binary
  ChipsetInit Binary Length.
**/
  UINT32                      ChipsetInitBinLen;

/** Offset 0x04FC - Pointer to NPHY Binary
  Nphy Binary Pointer.
**/
  UINT32                      NphyBinPtr;

/** Offset 0x0500 - Length of NPHY Binary
  Nphy Binary Length.
**/
  UINT32                      NphyBinLen;

/** Offset 0x0504 - Pointer to SYNPS PHY Binary
  Synps Binary Pointer.
**/
  UINT32                      SynpsPhyBinPtr;

/** Offset 0x0508 - Length of SYNPS PHY Binary
  Synps Binary Length.
**/
  UINT32                      SynpsPhyBinLen;

/** Offset 0x050C - FIVR Dynamic Power Management
  Enable/Disable FIVR Dynamic Power Management.
  $EN_DIS
**/
  UINT8                       PchFivrDynPm;

/** Offset 0x050D
**/
  UINT8                       Rsvd170;

/** Offset 0x050E - External V1P05 Icc Max Value
  Granularity of this setting is 1mA and maximal possible value is 500mA
**/
  UINT16                      PchFivrExtV1p05RailIccMaximum;

/** Offset 0x0510 - External Vnn Icc Max Value that will be used in S0ix/Sx states
  Granularity of this setting is 1mA and maximal possible value is 500mA
**/
  UINT16                      PchFivrExtVnnRailIccMaximum;

/** Offset 0x0512 - External Vnn Icc Max Value that will be used in Sx states
  Use only if Ext Vnn Rail config is different in Sx. Granularity of this setting
  is 1mA and maximal possible value is 500mA
**/
  UINT16                      PchFivrExtVnnRailSxIccMaximum;

/** Offset 0x0514 - USB Audio Offload enable
  Enable/Disable USB Audio Offload capabilites. 0: disabled, 1: enabled (default)
  $EN_DIS
**/
  UINT8                       PchXhciUaolEnable;

/** Offset 0x0515 - PCH xHCI enable HS Interrupt IN Alarm
  PCH xHCI enable HS Interrupt IN Alarm. 0: disabled (default), 1: enabled
  $EN_DIS
**/
  UINT8                       PchXhciHsiiEnable;

/** Offset 0x0516
**/
  UINT8                       Rsvd175[2];

/** Offset 0x0518 - PCH GPIOV2 Unlock Data Buffer Address
  Address of GPIO Unlock Data buffer
**/
  UINT32                      PchGpioUnlockDataPtr;

/** Offset 0x051C - PCH GPIOV2 Unlock Data Buffer Size
  Size of PCH GPIO Unlock Data Buffer
**/
  UINT32                      PchGpioUnlockDataSize;

/** Offset 0x0520 - PchPostMemRsvd
  Reserved for PCH Post-Mem
  $EN_DIS
**/
  UINT8                       PchPostMemRsvd[2];

/** Offset 0x0522 - CNVi Configuration
  This option allows for automatic detection of Connectivity Solution. [Auto Detection]
  assumes that CNVi will be enabled when available, [Disable] allows for disabling CNVi.
  0:Disable, 1:Auto
**/
  UINT8                       CnviMode;

/** Offset 0x0523 - CNVi Wi-Fi Core
  Enable/Disable CNVi Wi-Fi Core, Default is ENABLE. 0: DISABLE, 1: ENABLE
  $EN_DIS
**/
  UINT8                       CnviWifiCore;

/** Offset 0x0524 - CNVi BT Core
  Enable/Disable CNVi BT Core, Default is ENABLE. 0: DISABLE, 1: ENABLE
  $EN_DIS
**/
  UINT8                       CnviBtCore;

/** Offset 0x0525 - CNVi BT Audio Offload
  Enable/Disable BT Audio Offload, Default is ENABLE. 0: DISABLE, 1: ENABLE
  $EN_DIS
**/
  UINT8                       CnviBtAudioOffload;

/** Offset 0x0526
**/
  UINT8                       Rsvd180[2];

/** Offset 0x0528 - CNVi RF_RESET pin muxing
  Select CNVi RF_RESET# pin depending on board routing. LP/P/M: GPP_A8 = 0x2942E408(default)
  or GPP_F4 = 0x194CE404. H/S: 0. Refer to GPIO_*_MUXING_CNVI_RF_RESET_* in GpioPins*.h.
**/
  UINT32                      CnviRfResetPinMux;

/** Offset 0x052C - CNVi CLKREQ pin muxing
  Select CNVi CLKREQ pin depending on board routing. LP/P/M: GPP_A9 = 0x3942E609(default)
  or GPP_F5 = 0x394CE605. H/S: 0. Refer to GPIO_*_MUXING_CNVI_CRF_XTAL_CLKREQ_* in
  GpioPins*.h.
**/
  UINT32                      CnviClkreqPinMux;

/** Offset 0x0530 - Enable Host C10 reporting through eSPI
  Enable/disable Host C10 reporting to Device via eSPI Virtual Wire.
  $EN_DIS
**/
  UINT8                       PchEspiHostC10ReportEnable;

/** Offset 0x0531 - PCH USB2 PHY Power Gating enable
  1: Will enable USB2 PHY SUS Well Power Gating, 0: Will not enable PG of USB2 PHY
  Sus Well PG
  $EN_DIS
**/
  UINT8                       PmcUsb2PhySusPgEnable;

/** Offset 0x0532 - PCH USB OverCurrent mapping enable
  1: Will program USB OC pin mapping in xHCI controller memory, 0: Will clear OC pin
  mapping allow for NOA usage of OC pins
  $EN_DIS
**/
  UINT8                       PchUsbOverCurrentEnable;

/** Offset 0x0533 - Espi Lgmr Memory Range decode
  This option enables or disables espi lgmr
  $EN_DIS
**/
  UINT8                       PchEspiLgmrEnable;

/** Offset 0x0534 - External V1P05 Control Ramp Timer value
  Hold off time to be used when changing the v1p05_ctrl for external bypass value in us
**/
  UINT8                       PchFivrExtV1p05RailCtrlRampTmr;

/** Offset 0x0535 - External VNN Control Ramp Timer value
  Hold off time to be used when changing the vnn_ctrl for external bypass value in us
**/
  UINT8                       PchFivrExtVnnRailCtrlRampTmr;

/** Offset 0x0536 - Set SATA DEVSLP GPIO Reset Config
  Set SATA DEVSLP GPIO Reset Config per port. 0x00 - GpioResetDefault, 0x01 - GpioResumeReset,
  0x03 - GpioHostDeepReset, 0x05 - GpioPlatformReset, 0x07 - GpioDswReset. One byte
  for each port, byte0 for port0, byte1 for port1, and so on.
**/
  UINT8                       SataPortsDevSlpResetConfig[8];

/** Offset 0x053E - PCHHOT# pin
  Enable PCHHOT# pin assertion when temperature is higher than PchHotLevel. 0: disable, 1: enable
  $EN_DIS
**/
  UINT8                       PchHotEnable;

/** Offset 0x053F - SATA LED
  SATA LED indicating SATA controller activity. 0: disable, 1: enable
  $EN_DIS
**/
  UINT8                       SataLedEnable;

/** Offset 0x0540 - VRAlert# Pin
  When VRAlert# feature pin is enabled and its state is '0', the PMC requests throttling
  to a T3 Tstate to the PCH throttling unit.. 0: disable, 1: enable
  $EN_DIS
**/
  UINT8                       PchPmVrAlert;

/** Offset 0x0541 - AMT Switch
  Enable/Disable. 0: Disable, 1: enable, Enable or disable AMT functionality.
  $EN_DIS
**/
  UINT8                       AmtEnabled;

/** Offset 0x0542 - WatchDog Timer Switch
  Enable/Disable. 0: Disable, 1: enable, Enable or disable WatchDog timer. Setting
  is invalid if AmtEnabled is 0.
  $EN_DIS
**/
  UINT8                       WatchDogEnabled;

/** Offset 0x0543 - PET Progress
  Enable/Disable. 0: Disable, 1: enable, Enable/Disable PET Events Progress to receive
  PET Events. Setting is invalid if AmtEnabled is 0.
  $EN_DIS
**/
  UINT8                       FwProgress;

/** Offset 0x0544 - SOL Switch
  Enable/Disable. 0: Disable, 1: enable, Serial Over Lan enable/disable state by Mebx.
  Setting is invalid if AmtEnabled is 0.
  $EN_DIS
**/
  UINT8                       AmtSolEnabled;

/** Offset 0x0545
**/
  UINT8                       Rsvd190;

/** Offset 0x0546 - OS Timer
  16 bits Value, Set OS watchdog timer. Setting is invalid if AmtEnabled is 0.
**/
  UINT16                      WatchDogTimerOs;

/** Offset 0x0548 - BIOS Timer
  16 bits Value, Set BIOS watchdog timer. Setting is invalid if AmtEnabled is 0.
**/
  UINT16                      WatchDogTimerBios;

/** Offset 0x054A - PCH PCIe root port connection type
  0: built-in device, 1:slot
**/
  UINT8                       PcieRpSlotImplemented[29];

/** Offset 0x0567 - PCIE RP Access Control Services Extended Capability
  Enable/Disable PCIE RP Access Control Services Extended Capability
**/
  UINT8                       PcieRpAcsEnabled[29];

/** Offset 0x0584 - PCIE RP Clock Power Management
  Enable/Disable PCIE RP Clock Power Management, even if disabled, CLKREQ# signal
  can still be controlled by L1 PM substates mechanism
**/
  UINT8                       PcieRpEnableCpm[29];

/** Offset 0x05A1
**/
  UINT8                       Rsvd200[3];

/** Offset 0x05A4 - PCIE RP Detect Timeout Ms
  The number of milliseconds within 0~65535 in reference code will wait for link to
  exit Detect state for enabled ports before assuming there is no device and potentially
  disabling the port.
**/
  UINT16                      PcieRpDetectTimeoutMs[29];

/** Offset 0x05DE - ModPHY SUS Power Domain Dynamic Gating
  Enable/Disable ModPHY SUS Power Domain Dynamic Gating. Setting not supported on
  PCH-H. 0: disable, 1: enable
  $EN_DIS
**/
  UINT8                       PmcModPhySusPgEnable;

/** Offset 0x05DF - V1p05-PHY supply external FET control
  Enable/Disable control using EXT_PWR_GATE# pin of external FET to power gate v1p05-PHY
  supply. 0: disable, 1: enable
  $EN_DIS
**/
  UINT8                       PmcV1p05PhyExtFetControlEn;

/** Offset 0x05E0 - V1p05-IS supply external FET control
  Enable/Disable control using EXT_PWR_GATE2# pin of external FET to power gate v1p05-IS
  supply. 0: disable, 1: enable
  $EN_DIS
**/
  UINT8                       PmcV1p05IsExtFetControlEn;

/** Offset 0x05E1 - Enable/Disable PavpEnable
  Enable(Default): Enable PavpEnable, Disable: Disable PavpEnable
  $EN_DIS
**/
  UINT8                       PavpEnable;

/** Offset 0x05E2 - Enable/Disable PeiGraphicsPeimInit
  <b>Enable(Default):</b> FSP will initialize the framebuffer and provide it via EFI_PEI_GRAPHICS_INFO_HOB.
  Disable: FSP will NOT initialize the framebuffer.
  $EN_DIS
**/
  UINT8                       PeiGraphicsPeimInit;

/** Offset 0x05E3 - Enable D3 Hot in TCSS
  This policy will enable/disable D3 hot support in IOM
  $EN_DIS
**/
  UINT8                       D3HotEnable;

/** Offset 0x05E4 - Enable or disable GNA device
  0=Disable, 1(Default)=Enable
  $EN_DIS
**/
  UINT8                       GnaEnable;

/** Offset 0x05E5
**/
  UINT8                       Rsvd210[3];

/** Offset 0x05E8 - TypeC port GPIO setting
  GPIO Ping number for Type C Aux Oritation setting, use the GpioPad that is defined
  in GpioPinsXXXH.h and GpioPinsXXXLp.h as argument.(XXX is platform name, Ex: Mtl
  = MeteorLake)
**/
  UINT32                      IomTypeCPortPadCfg[12];

/** Offset 0x0618 - CPU USB3 Port Over Current Pin
  Describe the specific over current pin number of USBC Port N.
**/
  UINT8                       CpuUsb3OverCurrentPin[8];

/** Offset 0x0620 - Enable D3 Cold in TCSS
  This policy will enable/disable D3 cold support in IOM
  $EN_DIS
**/
  UINT8                       D3ColdEnable;

/** Offset 0x0621 - Enable/Disable PCIe tunneling for USB4
  Enable/Disable PCIe tunneling for USB4, default is enable
  $EN_DIS
**/
  UINT8                       ITbtPcieTunnelingForUsb4;

/** Offset 0x0622 - Enable/Disable SkipFspGop
  Enable: Skip FSP provided GOP driver, Disable(Default): Use FSP provided GOP driver
  $EN_DIS
**/
  UINT8                       SkipFspGop;

/** Offset 0x0623 - Enable/Disable VPU Device
  Enable(Default): Enable VPU Device, Disable: Disable VPU Device
  $EN_DIS
**/
  UINT8                       VpuEnable;

/** Offset 0x0624 - TC State in TCSS
  This TC C-State Limit in IOM
**/
  UINT8                       TcCstateLimit;

/** Offset 0x0625 - Display port support policy in TCSS
  This policy will enable/disable Display port support in IOM
  $EN_DIS
**/
  UINT8                       TcNotifyIgd;

/** Offset 0x0626
**/
  UINT8                       Rsvd220[2];

/** Offset 0x0628 - Intel Graphics VBT (Video BIOS Table) Size
  Size of Internal Graphics VBT Image
**/
  UINT32                      VbtSize;

/** Offset 0x062C - Platform LID Status for LFP Displays.
  LFP Display Lid Status (LID_STATUS enum): 0 (Default): LidClosed, 1: LidOpen.
  0: LidClosed, 1: LidOpen
**/
  UINT8                       LidStatus;

/** Offset 0x062D - PchPostMemRsvd
  Reserved for PCH Post-Mem
  $EN_DIS
**/
  UINT8                       SaPostMemRsvd[8];

/** Offset 0x0635 - Enable VMD controller
  Enable/disable to VMD controller.0: Disable; 1: Enable(Default)
  $EN_DIS
**/
  UINT8                       VmdEnable;

/** Offset 0x0636 - Enable VMD Global Mapping
  Enable/disable to VMD controller.0: Disable(Default); 1: Enable
  $EN_DIS
**/
  UINT8                       VmdGlobalMapping;

/** Offset 0x0637 - Map port under VMD
  Map/UnMap port under VMD
  $EN_DIS
**/
  UINT8                       VmdPort[31];

/** Offset 0x0656 - VMD Port Bus
  VMD Root port bus number.
**/
  UINT8                       VmdPortBus[31];

/** Offset 0x0675 - VMD Port Device
  VMD Root port device number.
**/
  UINT8                       VmdPortDev[31];

/** Offset 0x0694 - VMD Port Func
  VMD Root port function number.
**/
  UINT8                       VmdPortFunc[31];

/** Offset 0x06B3
**/
  UINT8                       Rsvd230;

/** Offset 0x06B4 - VMD Variable
  VMD Variable Pointer.
**/
  UINT32                      VmdVariablePtr;

/** Offset 0x06B8 - Temporary CfgBar address for VMD
  VMD Variable Pointer.
**/
  UINT32                      VmdCfgBarBase;

/** Offset 0x06BC - Temporary MemBar1 address for VMD
  VMD Variable Pointer.
**/
  UINT32                      VmdMemBar1Base;

/** Offset 0x06C0 - Temporary MemBar2 address for VMD
  VMD Variable Pointer.
**/
  UINT32                      VmdMemBar2Base;

/** Offset 0x06C4 - TCSS CPU USB PDO Programming
  Enable/disable PDO programming for TCSS CPU USB in PEI phase. Disabling will allow
  for programming during later phase. 1: enable, 0: disable
  $EN_DIS
**/
  UINT8                       TcssCpuUsbPdoProgramming;

/** Offset 0x06C5 - Enable/Disable PMC-PD Solution
  This policy will enable/disable PMC-PD Solution vs EC-TCPC Solution
  $EN_DIS
**/
  UINT8                       PmcPdEnable;

/** Offset 0x06C6 - TCSS Aux Orientation Override Enable
  Bits 0, 2, ... 10 control override enables, bits 1, 3, ... 11 control overrides
**/
  UINT16                      TcssAuxOri;

/** Offset 0x06C8 - TCSS HSL Orientation Override Enable
  Bits 0, 2, ... 10 control override enables, bits 1, 3, ... 11 control overrides
**/
  UINT16                      TcssHslOri;

/** Offset 0x06CA - USB override in IOM
  This policy will enable/disable USB Connect override in IOM
  $EN_DIS
**/
  UINT8                       UsbOverride;

/** Offset 0x06CB - ITBT Root Port Enable
  ITBT Root Port Enable, 0:Disable, 1:Enable
  0:Disable, 1:Enable
**/
  UINT8                       ITbtPcieRootPortEn[4];

/** Offset 0x06CF - TCSS USB Port Enable
  Bits 0, 1, ... max Type C port control enables
**/
  UINT8                       UsbTcPortEn;

/** Offset 0x06D0 - ITBTForcePowerOn Timeout value
  ITBTForcePowerOn value. Specified increment values in miliseconds. Range is 0-1000.
  100 = 100 ms.
**/
  UINT16                      ITbtForcePowerOnTimeoutInMs;

/** Offset 0x06D2 - ITbtConnectTopology Timeout value
  ITbtConnectTopologyTimeout value. Specified increment values in miliseconds. Range
  is 0-10000. 100 = 100 ms.
**/
  UINT16                      ITbtConnectTopologyTimeoutInMs;

/** Offset 0x06D4 - VCCST request for IOM
  This policy will enable/disable VCCST and also decides if message would be replayed in S4/S5
  $EN_DIS
**/
  UINT8                       VccSt;

/** Offset 0x06D5
**/
  UINT8                       Rsvd240[1];

/** Offset 0x06D6 - ITBT DMA LTR
  TCSS DMA1, DMA2 LTR value
**/
  UINT16                      ITbtDmaLtr[2];

/** Offset 0x06DA - Enable/Disable CrashLog
  Enable(Default): Enable CPU CrashLog, Disable: Disable CPU CrashLog
  $EN_DIS
**/
  UINT8                       CpuCrashLogEnable;

/** Offset 0x06DB - Enable/Disable PTM
  This policy will enable/disable Precision Time Measurement for TCSS PCIe Root Ports
  $EN_DIS
**/
  UINT8                       PtmEnabled[4];

/** Offset 0x06DF - PCIE RP Ltr Enable
  Latency Tolerance Reporting Mechanism.
**/
  UINT8                       SaPcieItbtRpLtrEnable[4];

/** Offset 0x06E3 - PCIE RP Snoop Latency Override Mode
  Latency Tolerance Reporting, Snoop Latency Override Mode.
**/
  UINT8                       SaPcieItbtRpSnoopLatencyOverrideMode[4];

/** Offset 0x06E7 - PCIE RP Snoop Latency Override Multiplier
  Latency Tolerance Reporting, Snoop Latency Override Multiplier.
**/
  UINT8                       SaPcieItbtRpSnoopLatencyOverrideMultiplier[4];

/** Offset 0x06EB
**/
  UINT8                       Rsvd250[1];

/** Offset 0x06EC - PCIE RP Snoop Latency Override Value
  Latency Tolerance Reporting, Snoop Latency Override Value.
**/
  UINT16                      SaPcieItbtRpSnoopLatencyOverrideValue[4];

/** Offset 0x06F4 - PCIE RP Non Snoop Latency Override Mode
  Latency Tolerance Reporting, Non-Snoop Latency Override Mode.
**/
  UINT8                       SaPcieItbtRpNonSnoopLatencyOverrideMode[4];

/** Offset 0x06F8 - PCIE RP Non Snoop Latency Override Multiplier
  Latency Tolerance Reporting, Non-Snoop Latency Override Multiplier.
**/
  UINT8                       SaPcieItbtRpNonSnoopLatencyOverrideMultiplier[4];

/** Offset 0x06FC - PCIE RP Non Snoop Latency Override Value
  Latency Tolerance Reporting, Non-Snoop Latency Override Value.
**/
  UINT16                      SaPcieItbtRpNonSnoopLatencyOverrideValue[4];

/** Offset 0x0704 - Force LTR Override
  Force LTR Override.
**/
  UINT8                       SaPcieItbtRpForceLtrOverride[4];

/** Offset 0x0708 - PCIE RP Ltr Config Lock
  0: Disable; 1: Enable.
**/
  UINT8                       SaPcieItbtRpLtrConfigLock[4];

/** Offset 0x070C - Enable or Disable TXT
  Enables utilization of additional hardware capabilities provided by Intel (R) Trusted
  Execution Technology. Changes require a full power cycle to take effect. <b>0:
  Disable</b>, 1: Enable.
  $EN_DIS
**/
  UINT8                       TxtEnable;

/** Offset 0x070D
**/
  UINT8                       Rsvd260[3];

/** Offset 0x0710 - CpuBistData
  Pointer CPU BIST Data
**/
  UINT32                      CpuBistData;

/** Offset 0x0714 - CpuMpPpi
  <b>Optional</b> pointer to the boot loader's implementation of EFI_PEI_MP_SERVICES_PPI.
  If not NULL, FSP will use the boot loader's implementation of multiprocessing.
  See section 5.1.4 of the FSP Integration Guide for more details.
**/
  UINT32                      CpuMpPpi;

/** Offset 0x0718 - Boot frequency
  Select the performance state that the BIOS will set starting from reset vector.
  0: Maximum battery performance. 1: Maximum non-turbo performance. <b>2: Turbo performance </b>
  0:0, 1:1, 2:2
**/
  UINT8                       BootFrequency;

/** Offset 0x0719
**/
  UINT8                       CpuPostMemRsvd[2];

/** Offset 0x071B
**/
  UINT8                       Rsvd270[1];

/** Offset 0x071C - PpinSupport to view Protected Processor Inventory Number
  PPIN Feature Support to view Protected Processor Inventory Number. Disable to turn
  off this feature. When 'PPIN Enable Mode' is selected, this shows second option
  where feature can be enabled based on EOM (End of Manufacturing) flag or it is
  always enabled
  0: Disable, 1: Enable, 2: Auto
**/
  UINT8                       PpinSupport;

/** Offset 0x071D - Memory size per thread allocated for Processor Trace
  Memory size per thread for Processor Trace. Processor Trace requires 2^N alignment
  and size in bytes per thread, from 4KB to 128MB.\n
  <b> 0xff:none </b>, 0:4k, 0x1:8k, 0x2:16k, 0x3:32k, 0x4:64k, 0x5:128k, 0x6:256k,
  0x7:512k, 0x8:1M, 0x9:2M, 0xa:4M. 0xb:8M, 0xc:16M, 0xd:32M, 0xe:64M, 0xf:128M
**/
  UINT8                       ProcessorTraceMemSize;

/** Offset 0x071E - Smbios Type4 Max Speed Override
  Provide the option for platform to override the MaxSpeed field of Smbios Type 4.
  If this value is not zero, it dominates the field.
**/
  UINT16                      SmbiosType4MaxSpeedOverride;

/** Offset 0x0720 - Advanced Encryption Standard (AES) feature
  Enable or Disable Advanced Encryption Standard (AES) feature; </b>0: Disable; <b>1: Enable
  $EN_DIS
**/
  UINT8                       AesEnable;

/** Offset 0x0721 - AvxDisable
  Enable/Disable the AVX and AVX2 Instructions
  0: Enable, 1: Disable
**/
  UINT8                       AvxDisable;

/** Offset 0x0722 - X2ApicEnable
  Enable/Disable X2APIC Operating Mode. When this option is configured as 'Enabled',
  'VT-d' option must be 'Enabled' and 'X2APIC Opt Out' option must be 'Disabled' as well.
  $EN_DIS
**/
  UINT8                       X2ApicEnable;

/** Offset 0x0723 - ProcHot Demotion Algorithm configuration
  ProcHot Demotion Algorithm configuration. Hardware Default/Disable; 0: Disable;<b>
  1: Hardware Default</b>
  0: Disable, 1: Hardware Default
**/
  UINT8                       ProcHotDemotion;

/** Offset 0x0724 - AC Split Lock
  Enable/Disable #AC check on split lock. <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       AcSplitLock;

/** Offset 0x0725 - GP Fault UC Lock
  Enable/Disable GP Fault check on UC lock. <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       GpfaultUcLock;

/** Offset 0x0726 - L2 QoS Enumeration
  Enable/Disable L2 QoS Enumeration. <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       L2QosEnumeration;

/** Offset 0x0727
**/
  UINT8                       EmbReserved1FspsUpd[1];

/** Offset 0x0728 - ReservedCpuPostMemProduction
  Reserved for CPU Post-Mem Production
  $EN_DIS
**/
  UINT8                       ReservedCpuPostMemProduction[56];

/** Offset 0x0760 - Enable Power Optimizer
  Enable DMI Power Optimizer on PCH side.
  $EN_DIS
**/
  UINT8                       PchPwrOptEnable;

/** Offset 0x0761 - PCH Flash Protection Ranges Write Enble
  Write or erase is blocked by hardware.
**/
  UINT8                       PchWriteProtectionEnable[5];

/** Offset 0x0766 - PCH Flash Protection Ranges Read Enble
  Read is blocked by hardware.
**/
  UINT8                       PchReadProtectionEnable[5];

/** Offset 0x076B
**/
  UINT8                       Rsvd280[1];

/** Offset 0x076C - PCH Protect Range Limit
  Left shifted address by 12 bits with address bits 11:0 are assumed to be FFFh for
  limit comparison.
**/
  UINT16                      PchProtectedRangeLimit[5];

/** Offset 0x0776 - PCH Protect Range Base
  Left shifted address by 12 bits with address bits 11:0 are assumed to be 0.
**/
  UINT16                      PchProtectedRangeBase[5];

/** Offset 0x0780 - Enable Pme
  Enable Azalia wake-on-ring.
  $EN_DIS
**/
  UINT8                       PchHdaPme;

/** Offset 0x0781 - HD Audio Link Frequency
  HDA Link Freq (PCH_HDAUDIO_LINK_FREQUENCY enum): 0: 6MHz, 1: 12MHz, 2: 24MHz.
  0: 6MHz, 1: 12MHz, 2: 24MHz
**/
  UINT8                       PchHdaLinkFrequency;

/** Offset 0x0782 - Enable PCH ISH SPI Cs0 pins assigned
  Set if ISH SPI Cs0 pins are to be enabled by BIOS. 0: Disable; 1: Enable.
**/
  UINT8                       PchIshSpiCs0Enable[1];

/** Offset 0x0783 - Enable PCH Io Apic Entry 24-119
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIoApicEntry24_119;

/** Offset 0x0784 - PCH Io Apic ID
  This member determines IOAPIC ID. Default is 0x02.
**/
  UINT8                       PchIoApicId;

/** Offset 0x0785 - Enable PCH ISH SPI pins assigned
  Set if ISH SPI native pins are to be enabled by BIOS. 0: Disable; 1: Enable.
**/
  UINT8                       PchIshSpiEnable[1];

/** Offset 0x0786 - Enable PCH ISH UART pins assigned
  Set if ISH UART native pins are to be enabled by BIOS. 0: Disable; 1: Enable.
**/
  UINT8                       PchIshUartEnable[2];

/** Offset 0x0788 - Enable PCH ISH I2C pins assigned
  Set if ISH I2C native pins are to be enabled by BIOS. 0: Disable; 1: Enable.
**/
  UINT8                       PchIshI2cEnable[3];

/** Offset 0x078B - Enable PCH ISH I3C pins assigned
  Set if ISH I3C native pins are to be enabled by BIOS. 0: Disable; 1: Enable.
**/
  UINT8                       PchIshI3cEnable;

/** Offset 0x078C - Enable PCH ISH GP pins assigned
  Set if ISH GP native pins are to be enabled by BIOS. 0: Disable; 1: Enable.
**/
  UINT8                       PchIshGpEnable[12];

/** Offset 0x0798 - PCH ISH PDT Unlock Msg
  0: False; 1: True.
  $EN_DIS
**/
  UINT8                       PchIshPdtUnlock;

/** Offset 0x0799 - PCH ISH Disable MSI Interrupts
  0: False; 1: True.
  $EN_DIS
**/
  UINT8                       PchIshMsiInterrupt;

/** Offset 0x079A - Enable PCH Lan LTR capabilty of PCH internal LAN
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchLanLtrEnable;

/** Offset 0x079B - Enable LOCKDOWN BIOS LOCK
  Enable the BIOS Lock feature and set EISS bit (D31:F5:RegDCh[5]) for the BIOS region
  protection.
  $EN_DIS
**/
  UINT8                       PchLockDownBiosLock;

/** Offset 0x079C - PCH Compatibility Revision ID
  This member describes whether or not the CRID feature of PCH should be enabled.
  $EN_DIS
**/
  UINT8                       PchCrid;

/** Offset 0x079D - RTC BIOS Interface Lock
  Enable RTC BIOS interface lock. When set, prevents RTC TS (BUC.TS) from being changed.
  $EN_DIS
**/
  UINT8                       RtcBiosInterfaceLock;

/** Offset 0x079E - RTC Cmos Memory Lock
  Enable RTC lower and upper 128 byte Lock bits to lock Bytes 38h-3Fh in the upper
  and and lower 128-byte bank of RTC RAM.
  $EN_DIS
**/
  UINT8                       RtcMemoryLock;

/** Offset 0x079F - Enable PCIE RP HotPlug
  Indicate whether the root port is hot plug available.
**/
  UINT8                       PcieRpHotPlug[29];

/** Offset 0x07BC - Enable PCIE RP Pm Sci
  Indicate whether the root port power manager SCI is enabled.
  $EN_DIS
**/
  UINT8                       PcieRpPmSci[29];

/** Offset 0x07D9 - Enable PCIE RP Transmitter Half Swing
  Indicate whether the Transmitter Half Swing is enabled.
**/
  UINT8                       PcieRpTransmitterHalfSwing[29];

/** Offset 0x07F6 - Enable PCIE RP Clk Req Detect
  Probe CLKREQ# signal before enabling CLKREQ# based power management.
**/
  UINT8                       PcieRpClkReqDetect[29];

/** Offset 0x0813 - PCIE RP Advanced Error Report
  Indicate whether the Advanced Error Reporting is enabled.
**/
  UINT8                       PcieRpAdvancedErrorReporting[29];

/** Offset 0x0830 - PCIE RP Unsupported Request Report
  Indicate whether the Unsupported Request Report is enabled.
**/
  UINT8                       PcieRpUnsupportedRequestReport[29];

/** Offset 0x084D - PCIE RP Fatal Error Report
  Indicate whether the Fatal Error Report is enabled.
**/
  UINT8                       PcieRpFatalErrorReport[29];

/** Offset 0x086A - PCIE RP No Fatal Error Report
  Indicate whether the No Fatal Error Report is enabled.
**/
  UINT8                       PcieRpNoFatalErrorReport[29];

/** Offset 0x0887 - PCIE RP Correctable Error Report
  Indicate whether the Correctable Error Report is enabled.
**/
  UINT8                       PcieRpCorrectableErrorReport[29];

/** Offset 0x08A4 - PCIE RP System Error On Fatal Error
  Indicate whether the System Error on Fatal Error is enabled.
**/
  UINT8                       PcieRpSystemErrorOnFatalError[29];

/** Offset 0x08C1 - PCIE RP System Error On Non Fatal Error
  Indicate whether the System Error on Non Fatal Error is enabled.
**/
  UINT8                       PcieRpSystemErrorOnNonFatalError[29];

/** Offset 0x08DE - PCIE RP System Error On Correctable Error
  Indicate whether the System Error on Correctable Error is enabled.
**/
  UINT8                       PcieRpSystemErrorOnCorrectableError[29];

/** Offset 0x08FB - PCIE RP Max Payload
  Max Payload Size supported, Default 256B, see enum PCH_PCIE_MAX_PAYLOAD.
**/
  UINT8                       PcieRpMaxPayload[29];

/** Offset 0x0918 - Touch Host Controller Assignment
  Assign THC 0x0:ThcAssignmentNone, 0x1:ThcAssignmentThc0, 0x2:ThcAssignmentThc1
**/
  UINT8                       ThcAssignment[2];

/** Offset 0x091A - Touch Host Controller Interrupt Pin Mux
  Set THC Pin Muxing Value if signal can be enabled on multiple pads. Refer to GPIO_*_MUXING_THC_SPIx_INTB_*
  for possible values.
**/
  UINT8                       ThcInterruptPinMuxing[8];

/** Offset 0x0922 - Touch Host Controller Mode
  Switch between Intel THC protocol and Industry standard HID Over SPI protocol. 0x0:Thc, 0x1:Hid
**/
  UINT8                       ThcMode[2];

/** Offset 0x0924 - Touch Host Controller Wake On Touch
  Based on this setting vGPIO for given THC will be in native mode, and additional
  _CRS for wake will be exposed in ACPI
**/
  UINT8                       ThcWakeOnTouch[2];

/** Offset 0x0926
**/
  UINT8                       Rsvd290[2];

/** Offset 0x0928 - Touch Host Controller Active Ltr
  Expose Active Ltr for OS driver to set
**/
  UINT32                      ThcActiveLtr[2];

/** Offset 0x0930 - Touch Host Controller Idle Ltr
  Expose Idle Ltr for OS driver to set
**/
  UINT32                      ThcIdleLtr[2];

/** Offset 0x0938 - Touch Host Controller Hid Over Spi ResetPad
  Hid Over Spi ResetPad
**/
  UINT32                      ThcResetPad[2];

/** Offset 0x0940 - Touch Host Controller Hid Over Spi ResetPad Trigger
  Hid Over Spi Reset Pad Trigger 0x0:Low, 0x1:High
**/
  UINT32                      ThcResetPadTrigger[2];

/** Offset 0x0948 - Touch Host Controller Hid Over Spi Connection Speed
  Hid Over Spi Connection Speed - SPI Frequency
**/
  UINT32                      ThcHidSpiConnectionSpeed[2];

/** Offset 0x0950 - Touch Host Controller Hid Over Spi Limit PacketSize
  When set, limits SPI read & write packet size to 64B. Otherwise, THC uses Max Soc
  packet size for SPI Read and Write 0x0- Max Soc Packet Size,  0x11 - 64 Bytes
**/
  UINT32                      ThcHidSpiLimitPacketSize[2];

/** Offset 0x0958 - Touch Host Controller Hid Over Spi Limit PacketSize
  Minimum amount of delay the THC/QUICKSPI driver must wait between end of write operation
  and begin of read operation. This value shall be in 10us multiples 0x0: Disabled,
  1-65535 (0xFFFF) - up to 655350 us
**/
  UINT32                      ThcPerformanceLimitation[2];

/** Offset 0x0960 - Touch Host Controller Hid Over Spi Input Report Header Address
  Hid Over Spi Input Report Header Address
**/
  UINT32                      ThcHidSpiInputReportHeaderAddress[2];

/** Offset 0x0968 - Touch Host Controller Hid Over Spi Input Report Body Address
  Hid Over Spi Input Report Body Address
**/
  UINT32                      ThcHidSpiInputReportBodyAddress[2];

/** Offset 0x0970 - Touch Host Controller Hid Over Spi Output Report Address
  Hid Over Spi Output Report Address
**/
  UINT32                      ThcHidSpiOutputReportAddress[2];

/** Offset 0x0978 - Touch Host Controller Hid Over Spi Read Opcode
  Hid Over Spi Read Opcode
**/
  UINT32                      ThcHidSpiReadOpcode[2];

/** Offset 0x0980 - Touch Host Controller Hid Over Spi Write Opcode
  Hid Over Spi Write Opcode
**/
  UINT32                      ThcHidSpiWriteOpcode[2];

/** Offset 0x0988 - Touch Host Controller Hid Over Spi Flags
  Hid Over Spi Flags 0x0:Single SPI Mode, 0x4000:Dual SPI Mode, 0x8000:Quad SPI Mode
**/
  UINT32                      ThcHidSpiFlags[2];

/** Offset 0x0990 - Touch Host Controller Hid Over Spi Reset Sequencing Delay [ms]
  Policy control for reset sequencing delay (ACPI _INI, _RST) default 300ms
**/
  UINT16                      ThcResetSequencingDelay[2];

/** Offset 0x0994 - PCIE RP Pcie Speed
  Determines each PCIE Port speed capability. 0: Auto; 1: Gen1; 2: Gen2; 3: Gen3 (see:
  PCIE_SPEED).
**/
  UINT8                       PcieRpPcieSpeed[29];

/** Offset 0x09B1 - PCIE RP Physical Slot Number
  Indicates the slot number for the root port. Default is the value as root port index.
**/
  UINT8                       PcieRpPhysicalSlotNumber[29];

/** Offset 0x09CE - PCIE RP Completion Timeout
  The root port completion timeout(see: PCIE_COMPLETION_TIMEOUT). Default is PchPcieCompletionTO_Default.
**/
  UINT8                       PcieRpCompletionTimeout[29];

/** Offset 0x09EB - PCIE RP Aspm
  The ASPM configuration of the root port (see: PCH_PCIE_ASPM_CONTROL). Default is
  PchPcieAspmAutoConfig.
**/
  UINT8                       PcieRpAspm[29];

/** Offset 0x0A08 - PCIE RP L1 Substates
  The L1 Substates configuration of the root port (see: PCH_PCIE_L1SUBSTATES_CONTROL).
  Default is PchPcieL1SubstatesL1_1_2.
**/
  UINT8                       PcieRpL1Substates[29];

/** Offset 0x0A25 - PCIE RP Ltr Enable
  Latency Tolerance Reporting Mechanism.
**/
  UINT8                       PcieRpLtrEnable[29];

/** Offset 0x0A42 - PCIE RP Ltr Config Lock
  0: Disable; 1: Enable.
**/
  UINT8                       PcieRpLtrConfigLock[29];

/** Offset 0x0A5F - PCIE RP override default settings for EQ
  Choose PCIe EQ method
  $EN_DIS
**/
  UINT8                       PcieEqOverrideDefault[29];

/** Offset 0x0A7C - PCIE RP choose EQ method
  Choose PCIe EQ method
  0: HardwareEq, 1: FixedEq
**/
  UINT8                       PcieGen3EqMethod[29];

/** Offset 0x0A99 - PCIE RP choose EQ mode
  Choose PCIe EQ mode
  0: PresetEq, 1: CoefficientEq
**/
  UINT8                       PcieGen3EqMode[29];

/** Offset 0x0AB6 - PCIE RP EQ local transmitter override
  Enable/Disable local transmitter override
  $EN_DIS
**/
  UINT8                       PcieGen3EqLocalTxOverrideEn[29];

/** Offset 0x0AD3 - PCI RP number of valid list entries
  Select number of presets or coefficients depending on the mode
**/
  UINT8                       PcieGen3EqPh3NoOfPresetOrCoeff[29];

/** Offset 0x0AF0 - PCIE RP pre-cursor coefficient list
  Provide a list of pre-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen3EqPh3PreCursor0List[29];

/** Offset 0x0B0D - PCIE RP post-cursor coefficient list
  Provide a list of post-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen3EqPh3PostCursor0List[29];

/** Offset 0x0B2A - PCIE RP pre-cursor coefficient list
  Provide a list of pre-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen3EqPh3PreCursor1List[29];

/** Offset 0x0B47 - PCIE RP post-cursor coefficient list
  Provide a list of post-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen3EqPh3PostCursor1List[29];

/** Offset 0x0B64 - PCIE RP pre-cursor coefficient list
  Provide a list of pre-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen3EqPh3PreCursor2List[29];

/** Offset 0x0B81 - PCIE RP post-cursor coefficient list
  Provide a list of post-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen3EqPh3PostCursor2List[29];

/** Offset 0x0B9E - PCIR RP pre-cursor coefficient list
  Provide a list of pre-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen3EqPh3PreCursor3List[29];

/** Offset 0x0BBB - PCIE RP post-cursor coefficient list
  Provide a list of post-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen3EqPh3PostCursor3List[29];

/** Offset 0x0BD8 - PCIE RP pre-cursor coefficient list
  Provide a list of pre-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen3EqPh3PreCursor4List[29];

/** Offset 0x0BF5 - PCIE RP post-cursor coefficient list
  Provide a list of post-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen3EqPh3PostCursor4List[29];

/** Offset 0x0C12 - PCIE RP pre-cursor coefficient list
  Provide a list of pre-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen3EqPh3PreCursor5List[29];

/** Offset 0x0C2F - PCIE RP post-cursor coefficient list
  Provide a list of post-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen3EqPh3PostCursor5List[29];

/** Offset 0x0C4C - PCIE RP pre-cursor coefficient list
  Provide a list of pre-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen3EqPh3PreCursor6List[29];

/** Offset 0x0C69 - PCIe post-cursor coefficient list
  Provide a list of post-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen3EqPh3PostCursor6List[29];

/** Offset 0x0C86 - PCIE RP pre-cursor coefficient list
  Provide a list of pre-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen3EqPh3PreCursor7List[29];

/** Offset 0x0CA3 - PCIE RP post-cursor coefficient list
  Provide a list of post-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen3EqPh3PostCursor7List[29];

/** Offset 0x0CC0 - PCIE RP pre-cursor coefficient list
  Provide a list of pre-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen3EqPh3PreCursor8List[29];

/** Offset 0x0CDD - PCIE RP post-cursor coefficient list
  Provide a list of post-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen3EqPh3PostCursor8List[29];

/** Offset 0x0CFA - PCIE RP pre-cursor coefficient list
  Provide a list of pre-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen3EqPh3PreCursor9List[29];

/** Offset 0x0D17 - PCIE RP post-cursor coefficient list
  Provide a list of post-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen3EqPh3PostCursor9List[29];

/** Offset 0x0D34 - PCIE RP preset list
  Provide a list of presets to be used during phase 3 EQ
**/
  UINT8                       PcieGen3EqPh3Preset0List[29];

/** Offset 0x0D51 - PCIe preset list
  Provide a list of presets to be used during phase 3 EQ
**/
  UINT8                       PcieGen3EqPh3Preset1List[29];

/** Offset 0x0D6E - PCIE RP preset list
  Provide a list of presets to be used during phase 3 EQ
**/
  UINT8                       PcieGen3EqPh3Preset2List[29];

/** Offset 0x0D8B - PCIE RP preset list
  Provide a list of presets to be used during phase 3 EQ
**/
  UINT8                       PcieGen3EqPh3Preset3List[29];

/** Offset 0x0DA8 - PCIE RP preset list
  Provide a list of presets to be used during phase 3 EQ
**/
  UINT8                       PcieGen3EqPh3Preset4List[29];

/** Offset 0x0DC5 - PCIE RP preset list
  Provide a list of presets to be used during phase 3 EQ
**/
  UINT8                       PcieGen3EqPh3Preset5List[29];

/** Offset 0x0DE2 - PCIE RP preset list
  Provide a list of presets to be used during phase 3 EQ
**/
  UINT8                       PcieGen3EqPh3Preset6List[29];

/** Offset 0x0DFF - PCIE RP preset list
  Provide a list of presets to be used during phase 3 EQ
**/
  UINT8                       PcieGen3EqPh3Preset7List[29];

/** Offset 0x0E1C - PCIE RP preset list
  Provide a list of presets to be used during phase 3 EQ
**/
  UINT8                       PcieGen3EqPh3Preset8List[29];

/** Offset 0x0E39 - PCIE RP preset list
  Provide a list of presets to be used during phase 3 EQ
**/
  UINT8                       PcieGen3EqPh3Preset9List[29];

/** Offset 0x0E56 - PCIE RP preset list
  Provide a list of presets to be used during phase 3 EQ
**/
  UINT8                       PcieGen3EqPh3Preset10List[29];

/** Offset 0x0E73 - PCIe EQ phase 1 downstream transmitter port preset
  Allows to select the downstream port preset value that will be used during phase
  1 of equalization
**/
  UINT8                       PcieGen3EqPh1DpTxPreset[29];

/** Offset 0x0E90 - PCIE RP EQ phase 1 upstream tranmitter port preset
  Allows to select the upstream port preset value that will be used during phase 1
  of equalization
**/
  UINT8                       PcieGen3EqPh1UpTxPreset[29];

/** Offset 0x0EAD - PCIE RP EQ phase 2 local transmitter override preset
  Allows to select the value of the preset used during phase 2 local transmitter override
**/
  UINT8                       PcieGen3EqPh2LocalTxOverridePreset[29];

/** Offset 0x0ECA - PCIE RP choose EQ method
  Choose PCIe EQ method
  0: HardwareEq, 1: FixedEq
**/
  UINT8                       PcieGen4EqMethod[29];

/** Offset 0x0EE7 - PCIE RP choose EQ mode
  Choose PCIe EQ mode
  0: PresetEq, 1: CoefficientEq
**/
  UINT8                       PcieGen4EqMode[29];

/** Offset 0x0F04 - PCIE RP EQ local transmitter override
  Enable/Disable local transmitter override
  $EN_DIS
**/
  UINT8                       PcieGen4EqLocalTxOverrideEn[29];

/** Offset 0x0F21 - PCI RP number of valid list entries
  Select number of presets or coefficients depending on the mode
**/
  UINT8                       PcieGen4EqPh3NoOfPresetOrCoeff[29];

/** Offset 0x0F3E - PCIE RP pre-cursor coefficient list
  Provide a list of pre-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen4EqPh3PreCursor0List[29];

/** Offset 0x0F5B - PCIE RP post-cursor coefficient list
  Provide a list of post-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen4EqPh3PostCursor0List[29];

/** Offset 0x0F78 - PCIE RP pre-cursor coefficient list
  Provide a list of pre-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen4EqPh3PreCursor1List[29];

/** Offset 0x0F95 - PCIE RP post-cursor coefficient list
  Provide a list of post-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen4EqPh3PostCursor1List[29];

/** Offset 0x0FB2 - PCIE RP pre-cursor coefficient list
  Provide a list of pre-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen4EqPh3PreCursor2List[29];

/** Offset 0x0FCF - PCIE RP post-cursor coefficient list
  Provide a list of post-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen4EqPh3PostCursor2List[29];

/** Offset 0x0FEC - PCIR RP pre-cursor coefficient list
  Provide a list of pre-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen4EqPh3PreCursor3List[29];

/** Offset 0x1009 - PCIE RP post-cursor coefficient list
  Provide a list of post-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen4EqPh3PostCursor3List[29];

/** Offset 0x1026 - PCIE RP pre-cursor coefficient list
  Provide a list of pre-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen4EqPh3PreCursor4List[29];

/** Offset 0x1043 - PCIE RP post-cursor coefficient list
  Provide a list of post-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen4EqPh3PostCursor4List[29];

/** Offset 0x1060 - PCIE RP pre-cursor coefficient list
  Provide a list of pre-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen4EqPh3PreCursor5List[29];

/** Offset 0x107D - PCIE RP post-cursor coefficient list
  Provide a list of post-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen4EqPh3PostCursor5List[29];

/** Offset 0x109A - PCIE RP pre-cursor coefficient list
  Provide a list of pre-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen4EqPh3PreCursor6List[29];

/** Offset 0x10B7 - PCIe post-cursor coefficient list
  Provide a list of post-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen4EqPh3PostCursor6List[29];

/** Offset 0x10D4 - PCIE RP pre-cursor coefficient list
  Provide a list of pre-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen4EqPh3PreCursor7List[29];

/** Offset 0x10F1 - PCIE RP post-cursor coefficient list
  Provide a list of post-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen4EqPh3PostCursor7List[29];

/** Offset 0x110E - PCIE RP pre-cursor coefficient list
  Provide a list of pre-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen4EqPh3PreCursor8List[29];

/** Offset 0x112B - PCIE RP post-cursor coefficient list
  Provide a list of post-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen4EqPh3PostCursor8List[29];

/** Offset 0x1148 - PCIE RP pre-cursor coefficient list
  Provide a list of pre-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen4EqPh3PreCursor9List[29];

/** Offset 0x1165 - PCIE RP post-cursor coefficient list
  Provide a list of post-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen4EqPh3PostCursor9List[29];

/** Offset 0x1182 - PCIE RP preset list
  Provide a list of presets to be used during phase 3 EQ
**/
  UINT8                       PcieGen4EqPh3Preset0List[29];

/** Offset 0x119F - PCIe preset list
  Provide a list of presets to be used during phase 3 EQ
**/
  UINT8                       PcieGen4EqPh3Preset1List[29];

/** Offset 0x11BC - PCIE RP preset list
  Provide a list of presets to be used during phase 3 EQ
**/
  UINT8                       PcieGen4EqPh3Preset2List[29];

/** Offset 0x11D9 - PCIE RP preset list
  Provide a list of presets to be used during phase 3 EQ
**/
  UINT8                       PcieGen4EqPh3Preset3List[29];

/** Offset 0x11F6 - PCIE RP preset list
  Provide a list of presets to be used during phase 3 EQ
**/
  UINT8                       PcieGen4EqPh3Preset4List[29];

/** Offset 0x1213 - PCIE RP preset list
  Provide a list of presets to be used during phase 3 EQ
**/
  UINT8                       PcieGen4EqPh3Preset5List[29];

/** Offset 0x1230 - PCIE RP preset list
  Provide a list of presets to be used during phase 3 EQ
**/
  UINT8                       PcieGen4EqPh3Preset6List[29];

/** Offset 0x124D - PCIE RP preset list
  Provide a list of presets to be used during phase 3 EQ
**/
  UINT8                       PcieGen4EqPh3Preset7List[29];

/** Offset 0x126A - PCIE RP preset list
  Provide a list of presets to be used during phase 3 EQ
**/
  UINT8                       PcieGen4EqPh3Preset8List[29];

/** Offset 0x1287 - PCIE RP preset list
  Provide a list of presets to be used during phase 3 EQ
**/
  UINT8                       PcieGen4EqPh3Preset9List[29];

/** Offset 0x12A4 - PCIE RP preset list
  Provide a list of presets to be used during phase 3 EQ
**/
  UINT8                       PcieGen4EqPh3Preset10List[29];

/** Offset 0x12C1 - PCIe EQ phase 1 downstream transmitter port preset
  Allows to select the downstream port preset value that will be used during phase
  1 of equalization
**/
  UINT8                       PcieGen4EqPh1DpTxPreset[29];

/** Offset 0x12DE - PCIE RP EQ phase 1 upstream tranmitter port preset
  Allows to select the upstream port preset value that will be used during phase 1
  of equalization
**/
  UINT8                       PcieGen4EqPh1UpTxPreset[29];

/** Offset 0x12FB - PCIE RP EQ phase 2 local transmitter override preset
  Allows to select the value of the preset used during phase 2 local transmitter override
**/
  UINT8                       PcieGen4EqPh2LocalTxOverridePreset[29];

/** Offset 0x1318 - PCIE RP choose EQ method
  Choose PCIe EQ method
  0: HardwareEq, 1: FixedEq
**/
  UINT8                       PcieGen5EqMethod[29];

/** Offset 0x1335 - PCIE RP choose EQ mode
  Choose PCIe EQ mode
  0: PresetEq, 1: CoefficientEq
**/
  UINT8                       PcieGen5EqMode[29];

/** Offset 0x1352 - PCIE RP EQ local transmitter override
  Enable/Disable local transmitter override
  $EN_DIS
**/
  UINT8                       PcieGen5EqLocalTxOverrideEn[29];

/** Offset 0x136F - PCI RP number of valid list entries
  Select number of presets or coefficients depending on the mode
**/
  UINT8                       PcieGen5EqPh3NoOfPresetOrCoeff[29];

/** Offset 0x138C - PCIE RP pre-cursor coefficient list
  Provide a list of pre-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen5EqPh3PreCursor0List[29];

/** Offset 0x13A9 - PCIE RP post-cursor coefficient list
  Provide a list of post-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen5EqPh3PostCursor0List[29];

/** Offset 0x13C6 - PCIE RP pre-cursor coefficient list
  Provide a list of pre-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen5EqPh3PreCursor1List[29];

/** Offset 0x13E3 - PCIE RP post-cursor coefficient list
  Provide a list of post-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen5EqPh3PostCursor1List[29];

/** Offset 0x1400 - PCIE RP pre-cursor coefficient list
  Provide a list of pre-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen5EqPh3PreCursor2List[29];

/** Offset 0x141D - PCIE RP post-cursor coefficient list
  Provide a list of post-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen5EqPh3PostCursor2List[29];

/** Offset 0x143A - PCIR RP pre-cursor coefficient list
  Provide a list of pre-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen5EqPh3PreCursor3List[29];

/** Offset 0x1457 - PCIE RP post-cursor coefficient list
  Provide a list of post-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen5EqPh3PostCursor3List[29];

/** Offset 0x1474 - PCIE RP pre-cursor coefficient list
  Provide a list of pre-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen5EqPh3PreCursor4List[29];

/** Offset 0x1491 - PCIE RP post-cursor coefficient list
  Provide a list of post-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen5EqPh3PostCursor4List[29];

/** Offset 0x14AE - PCIE RP pre-cursor coefficient list
  Provide a list of pre-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen5EqPh3PreCursor5List[29];

/** Offset 0x14CB - PCIE RP post-cursor coefficient list
  Provide a list of post-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen5EqPh3PostCursor5List[29];

/** Offset 0x14E8 - PCIE RP pre-cursor coefficient list
  Provide a list of pre-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen5EqPh3PreCursor6List[29];

/** Offset 0x1505 - PCIe post-cursor coefficient list
  Provide a list of post-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen5EqPh3PostCursor6List[29];

/** Offset 0x1522 - PCIE RP pre-cursor coefficient list
  Provide a list of pre-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen5EqPh3PreCursor7List[29];

/** Offset 0x153F - PCIE RP post-cursor coefficient list
  Provide a list of post-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen5EqPh3PostCursor7List[29];

/** Offset 0x155C - PCIE RP pre-cursor coefficient list
  Provide a list of pre-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen5EqPh3PreCursor8List[29];

/** Offset 0x1579 - PCIE RP post-cursor coefficient list
  Provide a list of post-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen5EqPh3PostCursor8List[29];

/** Offset 0x1596 - PCIE RP pre-cursor coefficient list
  Provide a list of pre-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen5EqPh3PreCursor9List[29];

/** Offset 0x15B3 - PCIE RP post-cursor coefficient list
  Provide a list of post-cursor coefficients to be used during phase 3 EQ
**/
  UINT8                       PcieGen5EqPh3PostCursor9List[29];

/** Offset 0x15D0 - PCIE RP preset list
  Provide a list of presets to be used during phase 3 EQ
**/
  UINT8                       PcieGen5EqPh3Preset0List[29];

/** Offset 0x15ED - PCIe preset list
  Provide a list of presets to be used during phase 3 EQ
**/
  UINT8                       PcieGen5EqPh3Preset1List[29];

/** Offset 0x160A - PCIE RP preset list
  Provide a list of presets to be used during phase 3 EQ
**/
  UINT8                       PcieGen5EqPh3Preset2List[29];

/** Offset 0x1627 - PCIE RP preset list
  Provide a list of presets to be used during phase 3 EQ
**/
  UINT8                       PcieGen5EqPh3Preset3List[29];

/** Offset 0x1644 - PCIE RP preset list
  Provide a list of presets to be used during phase 3 EQ
**/
  UINT8                       PcieGen5EqPh3Preset4List[29];

/** Offset 0x1661 - PCIE RP preset list
  Provide a list of presets to be used during phase 3 EQ
**/
  UINT8                       PcieGen5EqPh3Preset5List[29];

/** Offset 0x167E - PCIE RP preset list
  Provide a list of presets to be used during phase 3 EQ
**/
  UINT8                       PcieGen5EqPh3Preset6List[29];

/** Offset 0x169B - PCIE RP preset list
  Provide a list of presets to be used during phase 3 EQ
**/
  UINT8                       PcieGen5EqPh3Preset7List[29];

/** Offset 0x16B8 - PCIE RP preset list
  Provide a list of presets to be used during phase 3 EQ
**/
  UINT8                       PcieGen5EqPh3Preset8List[29];

/** Offset 0x16D5 - PCIE RP preset list
  Provide a list of presets to be used during phase 3 EQ
**/
  UINT8                       PcieGen5EqPh3Preset9List[29];

/** Offset 0x16F2 - PCIE RP preset list
  Provide a list of presets to be used during phase 3 EQ
**/
  UINT8                       PcieGen5EqPh3Preset10List[29];

/** Offset 0x170F - PCIe EQ phase 1 downstream transmitter port preset
  Allows to select the downstream port preset value that will be used during phase
  1 of equalization
**/
  UINT8                       PcieGen5EqPh1DpTxPreset[29];

/** Offset 0x172C - PCIE RP EQ phase 1 upstream tranmitter port preset
  Allows to select the upstream port preset value that will be used during phase 1
  of equalization
**/
  UINT8                       PcieGen5EqPh1UpTxPreset[29];

/** Offset 0x1749 - PCIE RP EQ phase 2 local transmitter override preset
  Allows to select the value of the preset used during phase 2 local transmitter override
**/
  UINT8                       PcieGen5EqPh2LocalTxOverridePreset[29];

/** Offset 0x1766 - Phase3 RP Gen3 EQ enable
  Phase3 Gen3 EQ enable. Disabled(0x0)(Default): Disable phase 3, Enabled(0x1): Enable phase 3
  0:Disable, 1:Enable, 2:Auto
**/
  UINT8                       PcieRpGen3EqPh3Bypass[29];

/** Offset 0x1783 - Phase3 RP Gen3 EQ enable
  Phase3 Gen3 EQ enable. Disabled(0x0)(Default): Disable phase 3, Enabled(0x1): Enable phase 3
  0:Disable, 1:Enable, 2:Auto
**/
  UINT8                       PcieRpGen4EqPh3Bypass[29];

/** Offset 0x17A0 - Phase3 RP Gen5 EQ enable
  Phase3 Gen5 EQ enable. Disabled(0x0)(Default): Disable phase 3, Enabled(0x1): Enable phase 3
  0:Disable, 1:Enable, 2:Auto
**/
  UINT8                       PcieRpGen5EqPh3Bypass[29];

/** Offset 0x17BD - Phase2-3 RP Gen3 EQ enable
  Phase2-3 Gen3 EQ enable. Disabled(0x0)(Default): Disable Phase2-3, Enabled(0x1):
  Enable Phase2-3
  0:Disable, 1:Enable, 2:Auto
**/
  UINT8                       PcieRpGen3EqPh23Bypass[29];

/** Offset 0x17DA - Phase2-3 RP Gen4 EQ enable
  Phase2-3 Gen4 EQ enable. Disabled(0x0)(Default): Disable Phase2-3, Enabled(0x1):
  Enable Phase2-3
  0:Disable, 1:Enable, 2:Auto
**/
  UINT8                       PcieRpGen4EqPh23Bypass[29];

/** Offset 0x17F7 - Phase2-3 RP Gen5 EQ enable
  Phase2-3 Gen5 EQ enable. Disabled(0x0)(Default): Disable Phase2-3, Enabled(0x1):
  Enable Phase2-3
  0:Disable, 1:Enable, 2:Auto
**/
  UINT8                       PcieRpGen5EqPh23Bypass[29];

/** Offset 0x1814 - RP Gen3 EQ Phase enable
  Gen3 EQ Phase enable. Disabled(0x0)(Default): Disable Eq Phase, Enabled(0x1): Enable Eq Phase
  0:Disable, 1:Enable, 2:Auto
**/
  UINT8                       PcieRpGen3EqPhBypass[29];

/** Offset 0x1831 - RP Gen4 EQ Phase enable
  Gen4 EQ Phase enable. Disabled(0x0)(Default): Disable Eq Phase, Enabled(0x1): Enable Eq Phase
  0:Disable, 1:Enable, 2:Auto
**/
  UINT8                       PcieRpGen4EqPhBypass[29];

/** Offset 0x184E - RP Gen5 EQ Phase enable
  Gen5 EQ Phase enable. Disabled(0x0)(Default): Disable Eq Phase, Enabled(0x1): Enable Eq Phase
  0:Disable, 1:Enable, 2:Auto
**/
  UINT8                       PcieRpGen5EqPhBypass[29];

/** Offset 0x186B - PCET Timer
  Preset/Coefficient Evaluation Timeout Gen3 PCET Timer. See PCIE_GEN3_PCET. Default
  is 0x0(2ms)
**/
  UINT8                       PcieGen3PcetTimer[29];

/** Offset 0x1888 - Gen4 PCET Timer
  Preset/Coefficient Evaluation Timeout - Gen4 PCET Timer. See PCIE_GEN4_PCET. Default
  is 0x0(2ms)
**/
  UINT8                       PcieGen4PcetTimer[29];

/** Offset 0x18A5 - Gen5 PCET Timer
  Preset/Coefficient Evaluation Timeout - Gen5 PCET Timer. See PCIE_GEN5_PCET. Default
  is 0x0(2ms)
**/
  UINT8                       PcieGen5PcetTimer[29];

/** Offset 0x18C2 - TS Lock Timer for Gen3
  Training Sequence Wait Latency For Presets/Coefficients Evaluation - Gen3 TS Lock
  Timer. See PCIE_GEN3_TS_LOCK_TIMER. Default is 0x0
**/
  UINT8                       PcieGen3TsLockTimer[29];

/** Offset 0x18DF - PTS Lock Timer for Gen4
  Training Sequence Wait Latency For Presets/Coefficients Evaluation - Gen4 TS Lock
  Timer. See PCIE_GEN4_TS_LCOK_TIMER. Default is 0x0
**/
  UINT8                       PcieGen4TsLockTimer[29];

/** Offset 0x18FC - PTS Lock Timer for Gen5
  Training Sequence Wait Latency For Presets/Coefficients Evaluation - Gen5 TS Lock
  Timer. See PCIE_GEN5_TS_LCOK_TIMER. Default is 0x0
**/
  UINT8                       PcieGen5TsLockTimer[29];

/** Offset 0x1919 - PCIE Secure Register Lock
  Describes whether Secure Register Lock is enaled or disabled. When it will be enbaled,
  load PcieRpSetSecuredRegisterLock recipe. 0: Disable(Default); 1: Enable
  $EN_DIS
**/
  UINT8                       PcieSetSecuredRegisterLock;

/** Offset 0x191A - DG Wait
  0(Default) = Disable, 1 = Enable
  $EN_DIS
**/
  UINT8                       DGWait;

/** Offset 0x191B - Enable/Disable ASPM Optionality Compliance
  Enable/Disable ASPM Optionality Compliance.
**/
  UINT8                       PcieRpTestAspmOc[29];

/** Offset 0x1938 - PCIe Configuration Dump
  Enable/Disable ASPM Optionality Compliance.
  0:Disable, 1:Enable
**/
  UINT8                       PcieCfgDump[29];

/** Offset 0x1955 - PCIE RP Enable Peer Memory Write
  This member describes whether Peer Memory Writes are enabled on the platform.
  $EN_DIS
**/
  UINT8                       PcieEnablePeerMemoryWrite[29];

/** Offset 0x1972 - PCIE Compliance Test Mode
  Compliance Test Mode shall be enabled when using Compliance Load Board.
  $EN_DIS
**/
  UINT8                       PcieComplianceTestMode;

/** Offset 0x1973 - PCIE Rp Function Swap
  Allows BIOS to use root port function number swapping when root port of function
  0 is disabled.
  $EN_DIS
**/
  UINT8                       PcieRpFunctionSwap;

/** Offset 0x1974 - PCIe Fia Programming
  Load Fia configuration if enable. 0: Disable; 1: Enable(Default).
  $EN_DIS
**/
  UINT8                       PcieFiaProgramming;

/** Offset 0x1975 - PCH Pm PME_B0_S5_DIS
  When cleared (default), wake events from PME_B0_STS are allowed in S5 if PME_B0_EN = 1.
  $EN_DIS
**/
  UINT8                       PchPmPmeB0S5Dis;

/** Offset 0x1976 - PCIE IMR
  Enables Isolated Memory Region for PCIe.
  $EN_DIS
**/
  UINT8                       PcieRpImrEnabled;

/** Offset 0x1977 - PCIE IMR port number
  Selects PCIE root port number for IMR feature.
**/
  UINT8                       PcieRpImrSelection;

/** Offset 0x1978 - PCH Pm Wol Enable Override
  Corresponds to the WOL Enable Override bit in the General PM Configuration B (GEN_PMCON_B) register.
  $EN_DIS
**/
  UINT8                       PchPmWolEnableOverride;

/** Offset 0x1979 - PCH Pm WoW lan Enable
  Determine if WLAN wake from Sx, corresponds to the HOST_WLAN_PP_EN bit in the PWRM_CFG3 register.
  $EN_DIS
**/
  UINT8                       PchPmWoWlanEnable;

/** Offset 0x197A - PCH Pm WoW lan DeepSx Enable
  Determine if WLAN wake from DeepSx, corresponds to the DSX_WLAN_PP_EN bit in the
  PWRM_CFG3 register.
  $EN_DIS
**/
  UINT8                       PchPmWoWlanDeepSxEnable;

/** Offset 0x197B - PCH Pm Lan Wake From DeepSx
  Determine if enable LAN to wake from deep Sx.
  $EN_DIS
**/
  UINT8                       PchPmLanWakeFromDeepSx;

/** Offset 0x197C - PCH Pm Deep Sx Pol
  Deep Sx Policy.
  $EN_DIS
**/
  UINT8                       PchPmDeepSxPol;

/** Offset 0x197D - PCH Pm Disable Dsx Ac Present Pulldown
  When Disable, PCH will internal pull down AC_PRESENT in deep SX and during G3 exit.
  $EN_DIS
**/
  UINT8                       PchPmDisableDsxAcPresentPulldown;

/** Offset 0x197E - PCH Pm Slp S3 Min Assert
  SLP_S3 Minimum Assertion Width Policy. Default is PchSlpS350ms.
**/
  UINT8                       PchPmSlpS3MinAssert;

/** Offset 0x197F - PCH Pm Slp S4 Min Assert
  SLP_S4 Minimum Assertion Width Policy. Default is PchSlpS44s.
**/
  UINT8                       PchPmSlpS4MinAssert;

/** Offset 0x1980 - PCH Pm Slp Sus Min Assert
  SLP_SUS Minimum Assertion Width Policy. Default is PchSlpSus4s.
**/
  UINT8                       PchPmSlpSusMinAssert;

/** Offset 0x1981 - PCH Pm Slp A Min Assert
  SLP_A Minimum Assertion Width Policy. Default is PchSlpA2s.
**/
  UINT8                       PchPmSlpAMinAssert;

/** Offset 0x1982 - USB Overcurrent Override for VISA
  This option overrides USB Over Current enablement state that USB OC will be disabled
  after enabling this option. Enable when VISA pin is muxed with USB OC
  $EN_DIS
**/
  UINT8                       PchEnableDbcObs;

/** Offset 0x1983 - PCH Pm Slp Strch Sus Up
  Enable SLP_X Stretching After SUS Well Power Up.
  $EN_DIS
**/
  UINT8                       PchPmSlpStrchSusUp;

/** Offset 0x1984 - PCH Pm Slp Lan Low Dc
  Enable/Disable SLP_LAN# Low on DC Power.
  $EN_DIS
**/
  UINT8                       PchPmSlpLanLowDc;

/** Offset 0x1985 - PCH Pm Pwr Btn Override Period
  PCH power button override period. 000b-4s, 001b-6s, 010b-8s, 011b-10s, 100b-12s, 101b-14s.
**/
  UINT8                       PchPmPwrBtnOverridePeriod;

/** Offset 0x1986 - PCH Pm Disable Native Power Button
  Power button native mode disable.
  $EN_DIS
**/
  UINT8                       PchPmDisableNativePowerButton;

/** Offset 0x1987 - PCH Pm ME_WAKE_STS
  Clear the ME_WAKE_STS bit in the Power and Reset Status (PRSTS) register.
  $EN_DIS
**/
  UINT8                       PchPmMeWakeSts;

/** Offset 0x1988 - PCH Pm WOL_OVR_WK_STS
  Clear the WOL_OVR_WK_STS bit in the Power and Reset Status (PRSTS) register.
  $EN_DIS
**/
  UINT8                       PchPmWolOvrWkSts;

/** Offset 0x1989 - PCH Pm Reset Power Cycle Duration
  Could be customized in the unit of second. Please refer to EDS for all support settings.
  0 is default, 1 is 1 second, 2 is 2 seconds, ...
**/
  UINT8                       PchPmPwrCycDur;

/** Offset 0x198A - PCH Pm Pcie Pll Ssc
  Specifies the Pcie Pll Spread Spectrum Percentage. The default is 0xFF: AUTO - No
  BIOS override.
**/
  UINT8                       PchPmPciePllSsc;

/** Offset 0x198B - PCH Legacy IO Low Latency Enable
  Set to enable low latency of legacy IO. <b>0: Disable</b>, 1: Enable
  $EN_DIS
**/
  UINT8                       PchLegacyIoLowLatency;

/** Offset 0x198C - PCH Sata Pwr Opt Enable
  SATA Power Optimizer on PCH side.
  $EN_DIS
**/
  UINT8                       SataPwrOptEnable;

/** Offset 0x198D - PCH Sata eSATA Speed Limit
  When enabled, BIOS will configure the PxSCTL.SPD to 2 to limit the eSATA port speed.
  $EN_DIS
**/
  UINT8                       EsataSpeedLimit;

/** Offset 0x198E - PCH Sata Speed Limit
  Indicates the maximum speed the SATA controller can support 0h: PchSataSpeedDefault.
**/
  UINT8                       SataSpeedLimit;

/** Offset 0x198F - Enable SATA Port HotPlug
  Enable SATA Port HotPlug.
**/
  UINT8                       SataPortsHotPlug[8];

/** Offset 0x1997 - Enable SATA Port Interlock Sw
  Enable SATA Port Interlock Sw.
**/
  UINT8                       SataPortsInterlockSw[8];

/** Offset 0x199F - Enable SATA Port External
  Enable SATA Port External.
**/
  UINT8                       SataPortsExternal[8];

/** Offset 0x19A7 - Enable SATA Port SpinUp
  Enable the COMRESET initialization Sequence to the device.
**/
  UINT8                       SataPortsSpinUp[8];

/** Offset 0x19AF - Enable SATA Port Solid State Drive
  0: HDD; 1: SSD.
**/
  UINT8                       SataPortsSolidStateDrive[8];

/** Offset 0x19B7 - Enable SATA Port Enable Dito Config
  Enable DEVSLP Idle Timeout settings (DmVal, DitoVal).
**/
  UINT8                       SataPortsEnableDitoConfig[8];

/** Offset 0x19BF - Enable SATA Port DmVal
  DITO multiplier. Default is 15.
**/
  UINT8                       SataPortsDmVal[8];

/** Offset 0x19C7 - Pch Dmi Aspm Ctrl
  ASPM configuration on the PCH side of the DMI/OPI Link. Default is <b>PchPcieAspmAutoConfig</b>
  0:Disabled, 1:L0s, 2:L1, 3:L0sL1, 4:Auto
**/
  UINT8                       PchDmiAspm;

/** Offset 0x19C8
**/
  UINT8                       Rsvd300[1];

/** Offset 0x19C9
**/
  UINT8                       UnusedUpdSpace2[1];

/** Offset 0x19CA - Enable SATA Port DmVal
  DEVSLP Idle Timeout (DITO), Default is 625.
**/
  UINT16                      SataPortsDitoVal[8];

/** Offset 0x19DA - Enable SATA Port ZpOdd
  Support zero power ODD.
**/
  UINT8                       SataPortsZpOdd[8];

/** Offset 0x19E2 - PCH Sata Rst Raid Alternate Id
  Enable RAID Alternate ID.
  $EN_DIS
**/
  UINT8                       SataRstRaidDeviceId;

/** Offset 0x19E3 - PCH Sata Rst Pcie Storage Remap enable
  Enable Intel RST for PCIe Storage remapping.
**/
  UINT8                       SataRstPcieEnable[3];

/** Offset 0x19E6 - PCH Sata Rst Pcie Storage Port
  Intel RST for PCIe Storage remapping - PCIe Port Selection (1-based, 0 = autodetect).
**/
  UINT8                       SataRstPcieStoragePort[3];

/** Offset 0x19E9 - PCH Sata Rst Pcie Device Reset Delay
  PCIe Storage Device Reset Delay in milliseconds. Default value is 100ms
**/
  UINT8                       SataRstPcieDeviceResetDelay[3];

/** Offset 0x19EC - UFS enable/disable
  Enable/Disable UFS controller, One byte for each Controller - (1,0) to enable controller
  0 and (0,1) to enable controller 1
  $EN_DIS
**/
  UINT8                       UfsEnable[2];

/** Offset 0x19EE - UFS Inline Encryption enable/disable
  Enable/Disable UFS Inline Encryption feature, One byte for each Controller - (1,0)
  to enable Inline Encryption for controller 0 and (0,1) to enable Inline Encryption
  for controller 1
  $EN_DIS
**/
  UINT8                       UfsInlineEncryption[2];

/** Offset 0x19F0 - IEH Mode
  Integrated Error Handler Mode, 0: Bypass, 1: Enable
  0: Bypass, 1:Enable
**/
  UINT8                       IehMode;

/** Offset 0x19F1 - SOC Thermal Throttling Suggested Setting
  Thermal Throttling Suggested Setting. When it is enabled, customized throttle levels
  are ignored but with native settings.
  $EN_DIS
**/
  UINT8                       SocTTSuggestedSetting;

/** Offset 0x19F2 - SOC Thermal Throttling Custimized T0Level Value
  Custimized T0Level value.
**/
  UINT16                      SocT0Level;

/** Offset 0x19F4 - SOC Thermal Throttling Custimized T1Level Value
  Custimized T1Level value.
**/
  UINT16                      SocT1Level;

/** Offset 0x19F6 - SOC Thermal Throttling Custimized T2Level Value
  Custimized T2Level value.
**/
  UINT16                      SocT2Level;

/** Offset 0x19F8 - Enable SOC Thermal Throttle
  Enable thermal throttle function.
  $EN_DIS
**/
  UINT8                       SocTTEnable;

/** Offset 0x19F9 - SOC PMSync State 13
  When set to 1 and the programmed GPIO pin is a 1, then PMSync state 13 will force
  at least T2 state.
  $EN_DIS
**/
  UINT8                       SocTTState13Enable;

/** Offset 0x19FA - SOC Thermal Throttle Lock
  Thermal Throttle Lock.
  $EN_DIS
**/
  UINT8                       SocTTLock;

/** Offset 0x19FB - PCH Thermal Throttling Suggested Setting
  Thermal Throttling Suggested Setting. When it is enabled, customized throttle levels
  are ignored but with native settings.
  $EN_DIS
**/
  UINT8                       PchTTSuggestedSetting;

/** Offset 0x19FC - PCH Thermal Throttling Custimized T0Level Value
  Custimized T0Level value.
**/
  UINT16                      PchT0Level;

/** Offset 0x19FE - PCH Thermal Throttling Custimized T1Level Value
  Custimized T1Level value.
**/
  UINT16                      PchT1Level;

/** Offset 0x1A00 - PCH Thermal Throttling Custimized T2Level Value
  Custimized T2Level value.
**/
  UINT16                      PchT2Level;

/** Offset 0x1A02 - Enable PCH Thermal Throttle
  Enable thermal throttle function.
  $EN_DIS
**/
  UINT8                       PchTTEnable;

/** Offset 0x1A03 - PCH PMSync State 13
  When set to 1 and the programmed GPIO pin is a 1, then PMSync state 13 will force
  at least T2 state.
  $EN_DIS
**/
  UINT8                       PchTTState13Enable;

/** Offset 0x1A04 - PCH Thermal Throttle Lock
  Thermal Throttle Lock.
  $EN_DIS
**/
  UINT8                       PchTTLock;

/** Offset 0x1A05 - IOE Thermal Throttling Suggested Setting
  IOE Thermal Throttling Suggested Setting. When it is enabled, customized throttle
  levels are ignored but with native settings.
  $EN_DIS
**/
  UINT8                       IoeTTSuggestedSetting;

/** Offset 0x1A06 - IOE Thermal Throttling Custimized T0Level Value
  Custimized IOE T0Level value.
**/
  UINT16                      IoeT0Level;

/** Offset 0x1A08 - IOE Thermal Throttling Custimized T1Level Value
  Custimized IOE T1Level value.
**/
  UINT16                      IoeT1Level;

/** Offset 0x1A0A - IOE Thermal Throttling Custimized T2Level Value
  Custimized IOE T2Level value.
**/
  UINT16                      IoeT2Level;

/** Offset 0x1A0C - Enable IOE Thermal Throttle
  Enable thermal throttle function.
  $EN_DIS
**/
  UINT8                       IoeTTEnable;

/** Offset 0x1A0D - IOE Thermal Throttle Lock
  Thermal Throttle Lock.
  $EN_DIS
**/
  UINT8                       IoeTTLock;

/** Offset 0x1A0E - DMI Thermal Sensor Autonomous Width Enable
  DMI Thermal Sensor Autonomous Width Enable.
  $EN_DIS
**/
  UINT8                       PchDmiTsawEn;

/** Offset 0x1A0F - DMI Thermal Sensor Suggested Setting
  DMT thermal sensor suggested representative values.
  $EN_DIS
**/
  UINT8                       DmiSuggestedSetting;

/** Offset 0x1A10 - Thermal Sensor 0 Target Width
  Thermal Sensor 0 Target Width.
  0:x1, 1:x2, 2:x4, 3:x8, 4:x16
**/
  UINT8                       DmiTS0TW;

/** Offset 0x1A11 - Thermal Sensor 1 Target Width
  Thermal Sensor 1 Target Width.
  0:x1, 1:x2, 2:x4, 3:x8, 4:x16
**/
  UINT8                       DmiTS1TW;

/** Offset 0x1A12 - Thermal Sensor 2 Target Width
  Thermal Sensor 2 Target Width.
  0:x1, 1:x2, 2:x4, 3:x8, 4:x16
**/
  UINT8                       DmiTS2TW;

/** Offset 0x1A13 - Thermal Sensor 3 Target Width
  Thermal Sensor 3 Target Width.
  0:x1, 1:x2, 2:x4, 3:x8, 4:x16
**/
  UINT8                       DmiTS3TW;

/** Offset 0x1A14 - Port 0 T1 Multipler
  Port 0 T1 Multipler.
**/
  UINT8                       SataP0T1M;

/** Offset 0x1A15 - Port 0 T2 Multipler
  Port 0 T2 Multipler.
**/
  UINT8                       SataP0T2M;

/** Offset 0x1A16 - Port 0 T3 Multipler
  Port 0 T3 Multipler.
**/
  UINT8                       SataP0T3M;

/** Offset 0x1A17 - Port 0 Tdispatch
  Port 0 Tdispatch.
**/
  UINT8                       SataP0TDisp;

/** Offset 0x1A18 - Port 1 T1 Multipler
  Port 1 T1 Multipler.
**/
  UINT8                       SataP1T1M;

/** Offset 0x1A19 - Port 1 T2 Multipler
  Port 1 T2 Multipler.
**/
  UINT8                       SataP1T2M;

/** Offset 0x1A1A - Port 1 T3 Multipler
  Port 1 T3 Multipler.
**/
  UINT8                       SataP1T3M;

/** Offset 0x1A1B - Port 1 Tdispatch
  Port 1 Tdispatch.
**/
  UINT8                       SataP1TDisp;

/** Offset 0x1A1C - Port 0 Tinactive
  Port 0 Tinactive.
**/
  UINT8                       SataP0Tinact;

/** Offset 0x1A1D - Port 0 Alternate Fast Init Tdispatch
  Port 0 Alternate Fast Init Tdispatch.
  $EN_DIS
**/
  UINT8                       SataP0TDispFinit;

/** Offset 0x1A1E - Port 1 Tinactive
  Port 1 Tinactive.
**/
  UINT8                       SataP1Tinact;

/** Offset 0x1A1F - Port 1 Alternate Fast Init Tdispatch
  Port 1 Alternate Fast Init Tdispatch.
  $EN_DIS
**/
  UINT8                       SataP1TDispFinit;

/** Offset 0x1A20 - Sata Thermal Throttling Suggested Setting
  Sata Thermal Throttling Suggested Setting.
  $EN_DIS
**/
  UINT8                       SataThermalSuggestedSetting;

/** Offset 0x1A21
**/
  UINT8                       Rsvd310;

/** Offset 0x1A22 - Thermal Device Temperature
  Decides the temperature.
**/
  UINT16                      PchTemperatureHotLevel;

/** Offset 0x1A24 - USB2 Port Over Current Pin
  Describe the specific over current pin number of USB 2.0 Port N.
**/
  UINT8                       Usb2OverCurrentPin[16];

/** Offset 0x1A34 - USB3 Port Over Current Pin
  Describe the specific over current pin number of USB 3.0 Port N.
**/
  UINT8                       Usb3OverCurrentPin[10];

/** Offset 0x1A3E - Enable xHCI LTR override
  Enables override of recommended LTR values for xHCI
  $EN_DIS
**/
  UINT8                       PchUsbLtrOverrideEnable;

/** Offset 0x1A3F
**/
  UINT8                       Rsvd320[1];

/** Offset 0x1A40 - xHCI High Idle Time LTR override
  Value used for overriding LTR recommendation for xHCI High Idle Time LTR setting
**/
  UINT32                      PchUsbLtrHighIdleTimeOverride;

/** Offset 0x1A44 - xHCI Medium Idle Time LTR override
  Value used for overriding LTR recommendation for xHCI Medium Idle Time LTR setting
**/
  UINT32                      PchUsbLtrMediumIdleTimeOverride;

/** Offset 0x1A48 - xHCI Low Idle Time LTR override
  Value used for overriding LTR recommendation for xHCI Low Idle Time LTR setting
**/
  UINT32                      PchUsbLtrLowIdleTimeOverride;

/** Offset 0x1A4C - Enable 8254 Static Clock Gating
  Set 8254CGE=1 is required for SLP_S0 support. However, set 8254CGE=1 in POST time
  might fail to boot legacy OS using 8254 timer. Make sure it is disabled to support
  legacy OS using 8254 timer. Also enable this while S0ix is enabled.
  $EN_DIS
**/
  UINT8                       Enable8254ClockGating;

/** Offset 0x1A4D - Enable 8254 Static Clock Gating On S3
  This is only applicable when Enable8254ClockGating is disabled. FSP will do the
  8254 CGE programming on S3 resume when Enable8254ClockGatingOnS3 is enabled. This
  avoids the SMI requirement for the programming.
  $EN_DIS
**/
  UINT8                       Enable8254ClockGatingOnS3;

/** Offset 0x1A4E - Enable TCO timer.
  When FALSE, it disables PCH ACPI timer, and stops TCO timer. NOTE: This will have
  huge power impact when it's enabled. If TCO timer is disabled, uCode ACPI timer
  emulation must be enabled, and WDAT table must not be exposed to the OS.
  $EN_DIS
**/
  UINT8                       EnableTcoTimer;

/** Offset 0x1A4F - Enable Timed GPIO 0.
  When FALSE, it disables Timed GPIO 0.
  $EN_DIS
**/
  UINT8                       EnableTimedGpio0;

/** Offset 0x1A50 - Enable Timed GPIO 1.
  When FALSE, it disables Timed GPIO 1.
  $EN_DIS
**/
  UINT8                       EnableTimedGpio1;

/** Offset 0x1A51
**/
  UINT8                       EmbReserved3FspsUpd[2];

/** Offset 0x1A53
**/
  UINT8                       Rsvd330[5];

/** Offset 0x1A58 - BgpdtHash[4]
  BgpdtHash values
**/
  UINT64                      BgpdtHash[4];

/** Offset 0x1A78 - BiosGuardAttr
  BiosGuardAttr default values
**/
  UINT32                      BiosGuardAttr;

/** Offset 0x1A7C
**/
  UINT8                       Rsvd340[4];

/** Offset 0x1A80 - BiosGuardModulePtr
  BiosGuardModulePtr default values
**/
  UINT64                      BiosGuardModulePtr;

/** Offset 0x1A88 - SendEcCmd
  SendEcCmd function pointer. \n
  @code typedef EFI_STATUS (EFIAPI *PLATFORM_SEND_EC_COMMAND) (IN EC_COMMAND_TYPE
  EcCmdType, IN UINT8  EcCmd, IN UINT8  SendData, IN OUT UINT8  *ReceiveData); @endcode
**/
  UINT64                      SendEcCmd;

/** Offset 0x1A90 - EcCmdProvisionEav
  Ephemeral Authorization Value default values. Provisions an ephemeral shared secret to the EC
**/
  UINT8                       EcCmdProvisionEav;

/** Offset 0x1A91 - EcCmdLock
  EcCmdLock default values. Locks Ephemeral Authorization Value sent previously
**/
  UINT8                       EcCmdLock;

/** Offset 0x1A92
**/
  UINT8                       Rsvd350[6];

/** Offset 0x1A98 - EcProvisionEav
  EcProvisionEav function pointer. \n
  @code typedef EFI_STATUS (EFIAPI *EC_PROVISION_EAV) (IN UINT32 Eav, OUT UINT8
  *ReturnValue); @endcode
**/
  UINT64                      EcProvisionEav;

/** Offset 0x1AA0 - EcBiosGuardCmdLock
  EcBiosGuardCmdLock function pointer. \n
  @code typedef EFI_STATUS (EFIAPI *EC_CMD_LOCK) (OUT UINT8 *ReturnValue); @endcode
**/
  UINT64                      EcBiosGuardCmdLock;

/** Offset 0x1AA8 - Skip Ssid Programming.
  When set to TRUE, silicon code will not do any SSID programming and platform code
  needs to handle that by itself properly.
  $EN_DIS
**/
  UINT8                       SiSkipSsidProgramming;

/** Offset 0x1AA9
**/
  UINT8                       Rsvd360;

/** Offset 0x1AAA - Change Default SVID
  Change the default SVID used in FSP to programming internal devices. This is only
  valid when SkipSsidProgramming is FALSE.
**/
  UINT16                      SiCustomizedSvid;

/** Offset 0x1AAC - Change Default SSID
  Change the default SSID used in FSP to programming internal devices. This is only
  valid when SkipSsidProgramming is FALSE.
**/
  UINT16                      SiCustomizedSsid;

/** Offset 0x1AAE
**/
  UINT8                       Rsvd370[2];

/** Offset 0x1AB0 - SVID SDID table Poniter.
  The address of the table of SVID SDID to customize each SVID SDID entry. This is
  only valid when SkipSsidProgramming is FALSE.
**/
  UINT32                      SiSsidTablePtr;

/** Offset 0x1AB4 - Number of ssid table.
  SiNumberOfSsidTableEntry should match the table entries created in SiSsidTablePtr.
  This is only valid when SkipSsidProgramming is FALSE.
**/
  UINT16                      SiNumberOfSsidTableEntry;

/** Offset 0x1AB6 - USB2 Port Reset Message Enable
  0: Disable USB2 Port Reset Message; 1: Enable USB2 Port Reset Message; This must
  be enable for USB2 Port those are paired with CPU XHCI Port
**/
  UINT8                       PortResetMessageEnable[16];

/** Offset 0x1AC6 - SATA RST Interrupt Mode
  Allowes to choose which interrupts will be implemented by SATA controller in RAID mode.
  0:Msix, 1:Msi, 2:Legacy
**/
  UINT8                       SataRstInterrupt;

/** Offset 0x1AC7 - Enable PS_ON.
  PS_ON is a new C10 state from the CPU on desktop SKUs that enables a lower power
  target that will be required by the California Energy Commission (CEC). When FALSE,
  PS_ON is to be disabled.
  $EN_DIS
**/
  UINT8                       PsOnEnable;

/** Offset 0x1AC8 - Pmc Cpu C10 Gate Pin Enable
  Enable/Disable platform support for CPU_C10_GATE# pin to control gating of CPU VccIO
  and VccSTG rails instead of SLP_S0# pin.
  $EN_DIS
**/
  UINT8                       PmcCpuC10GatePinEnable;

/** Offset 0x1AC9 - Pch Dmi Aspm Ctrl
  ASPM configuration on the PCH side of the DMI/OPI Link. Default is <b>PchPcieAspmAutoConfig</b>
  0:Disabled, 1:L0s, 2:L1, 3:L0sL1, 4:Auto
**/
  UINT8                       PchDmiAspmCtrl;

/** Offset 0x1ACA - PchDmiCwbEnable
  Central Write Buffer feature configurable and enabled by default
  $EN_DIS
**/
  UINT8                       PchDmiCwbEnable;

/** Offset 0x1ACB - OS IDLE Mode Enable
  Enable/Disable OS Idle Mode
  $EN_DIS
**/
  UINT8                       PmcOsIdleEnable;

/** Offset 0x1ACC - S0ix Auto-Demotion
  Enable/Disable the Low Power Mode Auto-Demotion Host Control feature.
  $EN_DIS
**/
  UINT8                       PchS0ixAutoDemotion;

/** Offset 0x1ACD - Latch Events C10 Exit
  When this bit is set to 1, SLP_S0# entry events in SLP_S0_DEBUG_REGx registers are
  captured on C10 exit (instead of C10 entry which is default)
  $EN_DIS
**/
  UINT8                       PchPmLatchEventsC10Exit;

/** Offset 0x1ACE - PMC ADR enable
  Enable/disable asynchronous DRAM refresh
  $EN_DIS
**/
  UINT8                       PmcAdrEn;

/** Offset 0x1ACF - PMC ADR timer configuration enable
  Enable/disable ADR timer configuration
  $EN_DIS
**/
  UINT8                       PmcAdrTimerEn;

/** Offset 0x1AD0 - PMC ADR phase 1 timer value
  Enable/disable ADR timer configuration
**/
  UINT8                       PmcAdrTimer1Val;

/** Offset 0x1AD1 - PMC ADR phase 1 timer multiplier value
  Specify the multiplier value for phase 1 ADR timer
**/
  UINT8                       PmcAdrMultiplier1Val;

/** Offset 0x1AD2 - PMC ADR host reset partition enable
  Specify whether PMC should set ADR_RST_STS bit after receiving Reset_Warn_Ack DMI message
  $EN_DIS
**/
  UINT8                       PmcAdrHostPartitionReset;

/** Offset 0x1AD3 - PMC ADR source select override enable
  Tells the FSP to update the source select with platform value
  $EN_DIS
**/
  UINT8                       PmcAdrSrcOverride;

/** Offset 0x1AD4 - PMC ADR source selection
  Specify which sources should cause ADR flow
**/
  UINT32                      PmcAdrSrcSel;

/** Offset 0x1AD8 - PMC WDT enable
  Enable/disable PMC WDT configuration
  $EN_DIS
**/
  UINT8                       PmcWdtTimerEn;

/** Offset 0x1AD9 - PCIe RootPort Clock Gating
  Describes whether the PCI Express Clock Gating for each root port is enabled by
  platform modules. 0: Disable; 1: Enable(Default).
  $EN_DIS
**/
  UINT8                       PcieClockGating[29];

/** Offset 0x1AF6 - PCIe RootPort Power Gating
  Describes whether the PCI Express Power Gating for each root port is enabled by
  platform modules. 0: Disable; 1: Enable(Default).
  $EN_DIS
**/
  UINT8                       PciePowerGating[29];

/** Offset 0x1B13 - FOMS Control Policy
  Choose the Foms Control Policy, <b>Default = 0 </b>
  0: Auto, 1: Gen3 Foms, 2: Gen4 Foms, 3: Gen3 and Gen4 Foms
**/
  UINT8                       PcieFomsCp[29];

/** Offset 0x1B30 - PCIe GPIO Assertion in Link Down
  Describes whether the PCIe GPIO Assertion in Link Down programming is enabled for
  each root portby platform modules. 0: Disable; 1: Enable(Default).
  $EN_DIS
**/
  UINT8                       LinkDownGpios[29];

/** Offset 0x1B4D - Enable the write to USB 3.0 TX Output Unique Transition Bit Mode for rate 3
  Enable the write to USB 3.0 TX Output Unique Transition Bit Mode for rate 3, Each
  value in array can be between 0-1. One byte for each port.
**/
  UINT8                       Usb3HsioTxRate3UniqTranEnable[10];

/** Offset 0x1B57 - USB 3.0 TX Output Unique Transition Bit Scale for rate 3
  USB 3.0 TX Output Unique Transition Bit Scale for rate 3, HSIO_TX_DWORD9[6:0], <b>Default
  = 4Ch</b>. One byte for each port.
**/
  UINT8                       Usb3HsioTxRate3UniqTran[10];

/** Offset 0x1B61 - Enable the write to USB 3.0 TX Output Unique Transition Bit Mode for rate 2
  Enable the write to USB 3.0 TX Output Unique Transition Bit Mode for rate 2, Each
  value in array can be between 0-1. One byte for each port.
**/
  UINT8                       Usb3HsioTxRate2UniqTranEnable[10];

/** Offset 0x1B6B - USB 3.0 TX Output Unique Transition Bit Scale for rate 2
  USB 3.0 TX Output Unique Transition Bit Scale for rate 2, HSIO_TX_DWORD9[14:8],
  <b>Default = 4Ch</b>. One byte for each port.
**/
  UINT8                       Usb3HsioTxRate2UniqTran[10];

/** Offset 0x1B75 - Enable the write to USB 3.0 TX Output Unique Transition Bit Mode for rate 1
  Enable the write to USB 3.0 TX Output Unique Transition Bit Mode for rate 1, Each
  value in array can be between 0-1. One byte for each port.
**/
  UINT8                       Usb3HsioTxRate1UniqTranEnable[10];

/** Offset 0x1B7F - USB 3.0 TX Output Unique Transition Bit Scale for rate 1
  USB 3.0 TX Output Unique Transition Bit Scale for rate 1, HSIO_TX_DWORD9[22:16],
  <b>Default = 4Ch</b>. One byte for each port.
**/
  UINT8                       Usb3HsioTxRate1UniqTran[10];

/** Offset 0x1B89 - Enable the write to USB 3.0 TX Output Unique Transition Bit Mode for rate 0
  Enable the write to USB 3.0 TX Output Unique Transition Bit Mode for rate 0, Each
  value in array can be between 0-1. One byte for each port.
**/
  UINT8                       Usb3HsioTxRate0UniqTranEnable[10];

/** Offset 0x1B93 - USB 3.0 TX Output Unique Transition Bit Scale for rate 0
  USB 3.0 TX Output Unique Transition Bit Scale for rate 0, HSIO_TX_DWORD9[30:24],
  <b>Default = 4Ch</b>. One byte for each port.
**/
  UINT8                       Usb3HsioTxRate0UniqTran[10];

/** Offset 0x1B9D - Skip PAM regsiter lock
  Enable: PAM register will not be locked by RC, platform code should lock it, Disable(Default):
  PAM registers will be locked by RC
  $EN_DIS
**/
  UINT8                       SkipPamLock;

/** Offset 0x1B9E - Enable/Disable IGFX RenderStandby
  Enable(Default): Enable IGFX RenderStandby, Disable: Disable IGFX RenderStandby
  $EN_DIS
**/
  UINT8                       RenderStandby;

/** Offset 0x1B9F - Enable/Disable GT Configuration
  Enable(Default): Configure GT for use, Disable: Skip GT Configuration
  $EN_DIS
**/
  UINT8                       ConfigureGT;

/** Offset 0x1BA0 - GT Frequency Limit
  0xFF: Auto(Default), 2: 100 Mhz, 3: 150 Mhz, 4: 200 Mhz, 5: 250 Mhz, 6: 300 Mhz,
  7: 350 Mhz, 8: 400 Mhz, 9: 450 Mhz, 0xA: 500 Mhz, 0xB: 550 Mhz, 0xC: 600 Mhz, 0xD:
  650 Mhz, 0xE: 700 Mhz, 0xF: 750 Mhz, 0x10: 800 Mhz, 0x11: 850 Mhz, 0x12:900 Mhz,
  0x13: 950 Mhz, 0x14: 1000 Mhz, 0x15: 1050 Mhz, 0x16: 1100 Mhz, 0x17: 1150 Mhz,
  0x18: 1200 Mhz
  0xFF: Auto(Default), 2: 100 Mhz, 3: 150 Mhz, 4: 200 Mhz, 5: 250 Mhz, 6: 300 Mhz,
  7: 350 Mhz, 8: 400 Mhz, 9: 450 Mhz, 0xA: 500 Mhz, 0xB: 550 Mhz, 0xC: 600 Mhz, 0xD:
  650 Mhz, 0xE: 700 Mhz, 0xF: 750 Mhz, 0x10: 800 Mhz, 0x11: 850 Mhz, 0x12:900 Mhz,
  0x13: 950 Mhz, 0x14: 1000 Mhz, 0x15: 1050 Mhz, 0x16: 1100 Mhz, 0x17: 1150 Mhz,
  0x18: 1200 Mhz
**/
  UINT8                       GtFreqMax;

/** Offset 0x1BA1 - Disable Turbo GT
   0=Disable: GT frequency is not limited, 1=Enable: Disables Turbo GT frequency
  $EN_DIS
**/
  UINT8                       DisableTurboGt;

/** Offset 0x1BA2 - Enable RC1p GT frequency request to PMA (provided all other conditions are met)
  0(Default)=Disable, 1=Enable
  $EN_DIS
**/
  UINT8                       RC1pGtFreqEnable;

/** Offset 0x1BA3 - Enable RC1p Media frequency request to PMA (provided all other conditions are met)
  0(Default)=Disable, 1=Enable
  $EN_DIS
**/
  UINT8                       RC1pMediaFreqEnable;

/** Offset 0x1BA4 - Enable TSN Multi-VC
  Enable/disable Multi Virtual Channels(VC) in TSN.
  $EN_DIS
**/
  UINT8                       PchTsnMultiVcEnable;

/** Offset 0x1BA5 - PMC Limit Powergating
  Enable/disable Limit PSF powergating to C3 and deeper states
  $EN_DIS
**/
  UINT8                       PmcLimitC3AndDeeperWA;

/** Offset 0x1BA6
**/
  UINT8                       Rsvd380[10];

/** Offset 0x1BB0 - LogoPixelHeight Address
  Address of LogoPixelHeight
**/
  UINT32                      LogoPixelHeight;

/** Offset 0x1BB4 - LogoPixelWidth Address
  Address of LogoPixelWidth
**/
  UINT32                      LogoPixelWidth;

/** Offset 0x1BB8 - Enable/Disable Media Configuration
  Enable(Default): Configure Media for use, Disable: Skip Media Configuration
  $EN_DIS
**/
  UINT8                       ConfigureMedia;

/** Offset 0x1BB9 - ITbt Usb4CmMode value
  ITbt Usb4CmMode value. 0:Firmware CM, 1:Software CM
**/
  UINT8                       Usb4CmMode;

/** Offset 0x1BBA
**/
  UINT8                       Rsvd390[2];

/** Offset 0x1BBC - HorizontalResolution for PEI Logo
  HorizontalResolution from PEIm Gfx for PEI Logo
**/
  UINT32                      HorizontalResolution;

/** Offset 0x1BC0 - VerticalResolution for PEI Logo
  VerticalResolution from PEIm Gfx for PEI Logo
**/
  UINT32                      VerticalResolution;

/** Offset 0x1BC4 - Enable/Disable IGFX Media Standby
  Enable(Default): Enable IGFX Media Standby, Disable: Disable IGFX MediaStandby
  $EN_DIS
**/
  UINT8                       MediaStandby;

/** Offset 0x1BC5 - SaPostMemTestRsvd
  Reserved for SA Post-Mem Test
  $EN_DIS
**/
  UINT8                       SaPostMemTestRsvd[32];

/** Offset 0x1BE5
**/
  UINT8                       SaFspsUpdRsvd[32];

/** Offset 0x1C05 - RSR feature
  Enable or Disable RSR feature; 0: Disable; <b>1: Enable </b>
  $EN_DIS
**/
  UINT8                       EnableRsr;

/** Offset 0x1C06 - ReservedCpuPostMem1
  Reserved for CPU Post-Mem 1
  $EN_DIS
**/
  UINT8                       ReservedCpuPostMem1[4];

/** Offset 0x1C0A - Enable or Disable HWP
  Enable/Disable Intel(R) Speed Shift Technology support. Enabling will expose the
  CPPC v2 interface to allow for hardware controlled P-states. 0: Disable; <b>1:
  Enable;</b>
  $EN_DIS
**/
  UINT8                       Hwp;

/** Offset 0x1C0B - Package Long duration turbo mode time
  Power Limit 1 Time Window value in seconds. The value may vary from 0 to 128. 0
  = default value (28 sec for Mobile and 8 sec for Desktop). Defines time window
  which Processor Base Power (TDP) value should be maintained. Valid values(Unit
  in seconds) 0 to 8 , 10 , 12 ,14 , 16 , 20 , 24 , 28 , 32 , 40 , 48 , 56 , 64 ,
  80 , 96 , 112 , 128
**/
  UINT8                       PowerLimit1Time;

/** Offset 0x1C0C - Short Duration Turbo Mode
  Enable/Disable Power Limit 2 override. If this option is disabled, BIOS will program
  the default values for Power Limit 2. 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       PowerLimit2;

/** Offset 0x1C0D - Turbo settings Lock
  Enable/Disable locking of Package Power Limit settings. When enabled, PACKAGE_POWER_LIMIT
  MSR will be locked and a reset will be required to unlock the register. <b>0: Disable;
  </b> 1: Enable
  $EN_DIS
**/
  UINT8                       TurboPowerLimitLock;

/** Offset 0x1C0E - Package PL3 time window
  Power Limit 3 Time Window value in Milli seconds. Indicates the time window over
  which Power Limit 3 value should be maintained. If the value is 0, BIOS leaves
  the hardware default value. Valid value: <b>0</b>, 3-8, 10, 12, 14, 16, 20, 24,
  28, 32, 40, 48, 56, 64.
**/
  UINT8                       PowerLimit3Time;

/** Offset 0x1C0F - Package PL3 Duty Cycle
  Specify the duty cycle in percentage that the CPU is required to maintain over the
  configured time window. Range is 0-100.
**/
  UINT8                       PowerLimit3DutyCycle;

/** Offset 0x1C10 - Package PL3 Lock
  Power Limit 3 Lock. When enabled PL3 configurations are locked during OS. When disabled
  PL3 configuration can be changed during OS. <b>0: Disable</b> ; 1:Enable
  $EN_DIS
**/
  UINT8                       PowerLimit3Lock;

/** Offset 0x1C11 - Package PL4 Lock
  Power Limit 4 Lock. When enabled PL4 configurations are locked during OS. When disabled
  PL4 configuration can be changed during OS. <b>0: Disable</b> ; 1:Enable
  $EN_DIS
**/
  UINT8                       PowerLimit4Lock;

/** Offset 0x1C12 - TCC Activation Offset
  TCC Activation Offset. Offset from factory set TCC activation temperature at which
  the Thermal Control Circuit must be activated. TCC will be activated at TCC Activation
  Temperature, in volts. <b>Default = 0h</b>.
**/
  UINT8                       TccActivationOffset;

/** Offset 0x1C13 - Tcc Offset Clamp Enable/Disable
  Tcc Offset Clamp for Runtime Average Temperature Limit (RATL) allows CPU to throttle
  below P1. <b>0: Disabled</b>; 1: Enabled.
  $EN_DIS
**/
  UINT8                       TccOffsetClamp;

/** Offset 0x1C14 - Tcc Offset Lock
  Tcc Offset Lock for Runtime Average Temperature Limit (RATL) to lock temperature
  target; <b>0: Disabled</b>; 1: Enabled.
  $EN_DIS
**/
  UINT8                       TccOffsetLock;

/** Offset 0x1C15 - Custom Ratio State Entries
  The number of custom ratio state entries, ranges from 0 to 40 for a valid custom
  ratio table. Sets the number of custom P-states. At least 2 states must be present
**/
  UINT8                       NumberOfEntries;

/** Offset 0x1C16 - Custom Short term Power Limit time window
  Power Limit 1 Time Window value in seconds. The value may vary from 0 to 128. 0
  = default value (28 sec for Mobile and 8 sec for Desktop). Defines time window
  which Processor Base Power (TDP) value should be maintained.
**/
  UINT8                       Custom1PowerLimit1Time;

/** Offset 0x1C17 - Custom Turbo Activation Ratio
  Custom value for Turbo Activation Ratio. Needs to be configured with valid values
  from LFM to Max Turbo. 0 means don't use custom value. Valid Range 0 to 255
**/
  UINT8                       Custom1TurboActivationRatio;

/** Offset 0x1C18 - Custom Config Tdp Control
  Config Tdp(Base Power) Control (0/1/2) value for custom cTDP(Assured Power) level
  1. Valid Range is 0 to 2
**/
  UINT8                       Custom1ConfigTdpControl;

/** Offset 0x1C19 - Custom Short term Power Limit time window
  Power Limit 1 Time Window value in seconds. The value may vary from 0 to 128. 0
  = default value (28 sec for Mobile and 8 sec for Desktop). Defines time window
  which Processor Base Power (TDP) value should be maintained.
**/
  UINT8                       Custom2PowerLimit1Time;

/** Offset 0x1C1A - Custom Turbo Activation Ratio
  Custom value for Turbo Activation Ratio. Needs to be configured with valid values
  from LFM to Max Turbo. 0 means don't use custom value. Valid Range 0 to 255
**/
  UINT8                       Custom2TurboActivationRatio;

/** Offset 0x1C1B - Custom Config Tdp Control
  Config Tdp(Base Power) Control (0/1/2) value for custom cTDP(Assured Power) level
  1. Valid Range is 0 to 2
**/
  UINT8                       Custom2ConfigTdpControl;

/** Offset 0x1C1C - Custom Short term Power Limit time window
  Power Limit 1 Time Window value in seconds. The value may vary from 0 to 128. 0
  = default value (28 sec for Mobile and 8 sec for Desktop). Defines time window
  which Processor Base Power (TDP) value should be maintained.
**/
  UINT8                       Custom3PowerLimit1Time;

/** Offset 0x1C1D - Custom Turbo Activation Ratio
  Custom value for Turbo Activation Ratio. Needs to be configured with valid values
  from LFM to Max Turbo. 0 means don't use custom value. Valid Range 0 to 255
**/
  UINT8                       Custom3TurboActivationRatio;

/** Offset 0x1C1E - Custom Config Tdp Control
  Config Tdp(Base Power) Control (0/1/2) value for custom cTDP(Assured Power) level
  1. Valid Range is 0 to 2
**/
  UINT8                       Custom3ConfigTdpControl;

/** Offset 0x1C1F - ConfigTdp mode settings Lock
  cTDP(Assured Power) Mode Lock sets the Lock bits on TURBO_ACTIVATION_RATIO and CONFIG_TDP_CONTROL.
  Note: When CTDP(Assured Power) Lock is enabled Custom ConfigTDP Count will be forced
  to 1 and Custom ConfigTDP Boot Index will be forced to 0. <b>0: Disable</b>; 1: Enable
  $EN_DIS
**/
  UINT8                       ConfigTdpLock;

/** Offset 0x1C20 - Load Configurable TDP SSDT
  Enables cTDP(Assured Power) control via runtime ACPI BIOS methods. This 'BIOS only'
  feature does not require EC or driver support. <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       ConfigTdpBios;

/** Offset 0x1C21 - PL1 Enable value
  Enable/Disable Platform Power Limit 1 programming. If this option is enabled, it
  activates the PL1 value to be used by the processor to limit the average power
  of given time window. <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       PsysPowerLimit1;

/** Offset 0x1C22 - PL1 timewindow
  Platform Power Limit 1 Time Window value in seconds. The value may vary from 0 to
  128. 0 = default values. Indicates the time window over which Platform Processor
  Base Power (TDP) value should be maintained. Valid values(Unit in seconds) 0 to
  8 , 10 , 12 ,14 , 16 , 20 , 24 , 28 , 32 , 40 , 48 , 56 , 64 , 80 , 96 , 112 , 128
**/
  UINT8                       PsysPowerLimit1Time;

/** Offset 0x1C23 - PL2 Enable Value
  Enable/Disable Platform Power Limit 2 programming. If this option is disabled, BIOS
  will program the default values for Platform Power Limit 2. <b>0: Disable</b>;
  1: Enable.
  $EN_DIS
**/
  UINT8                       PsysPowerLimit2;

/** Offset 0x1C24 - Enable or Disable MLC Streamer Prefetcher
  Enable or Disable MLC Streamer Prefetcher; 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       MlcStreamerPrefetcher;

/** Offset 0x1C25 - Enable or Disable MLC Spatial Prefetcher
  Enable or Disable MLC Spatial Prefetcher; 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       MlcSpatialPrefetcher;

/** Offset 0x1C26 - Enable or Disable Monitor /MWAIT instructions
  Enable/Disable MonitorMWait, if Disable MonitorMwait, the AP threads Idle Manner
  should not set in MWAIT Loop. 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       MonitorMwaitEnable;

/** Offset 0x1C27 - Enable or Disable initialization of machine check registers
  Enable or Disable initialization of machine check registers; 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       MachineCheckEnable;

/** Offset 0x1C28 - AP Idle Manner of waiting for SIPI
  AP threads Idle Manner for waiting signal to run. 1: HALT loop; <b>2: MWAIT loop</b>;
  3: RUN loop.
  1: HALT loop, 2: MWAIT loop, 3: RUN loop
**/
  UINT8                       ApIdleManner;

/** Offset 0x1C29 - Control on Processor Trace output scheme
  Control on Processor Trace output scheme; <b>0: Single Range Output</b>; 1: ToPA Output.
  0: Single Range Output, 1: ToPA Output
**/
  UINT8                       ProcessorTraceOutputScheme;

/** Offset 0x1C2A - Enable or Disable Processor Trace feature
  Enable or Disable Processor Trace feature; <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       ProcessorTraceEnable;

/** Offset 0x1C2B - Enable or Disable Intel SpeedStep Technology
  Allows more than two frequency ranges to be supported. 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       Eist;

/** Offset 0x1C2C - Enable or Disable Energy Efficient P-state
  Enable/Disable Energy Efficient P-state feature. When set to 0, will disable access
  to ENERGY_PERFORMANCE_BIAS MSR and CPUID Function will read 0 indicating no support
  for Energy Efficient policy setting. When set to 1 will enable access to ENERGY_PERFORMANCE_BIAS
  MSR and CPUID Function will read 1 indicating Energy Efficient policy setting is
  supported. 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       EnergyEfficientPState;

/** Offset 0x1C2D - Enable or Disable Energy Efficient Turbo
  Enable/Disable Energy Efficient Turbo Feature. This feature will opportunistically
  lower the turbo frequency to increase efficiency. Recommended only to disable in
  overclocking situations where turbo frequency must remain constant. Otherwise,
  leave enabled. <b>0: Disable</b>; 1: Enable
  $EN_DIS
**/
  UINT8                       EnergyEfficientTurbo;

/** Offset 0x1C2E - Enable or Disable T states
  Enable or Disable T states; <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       TStates;

/** Offset 0x1C2F - Enable or Disable Bi-Directional PROCHOT#
  Enable or Disable Bi-Directional PROCHOT#; 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       BiProcHot;

/** Offset 0x1C30 - Enable or Disable PROCHOT# signal being driven externally
  Enable or Disable PROCHOT# signal being driven externally; 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       DisableProcHotOut;

/** Offset 0x1C31 - Enable or Disable PROCHOT# Response
  Enable or Disable PROCHOT# Response; <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       ProcHotResponse;

/** Offset 0x1C32 - Enable or Disable VR Thermal Alert
  Enable or Disable VR Thermal Alert; <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       DisableVrThermalAlert;

/** Offset 0x1C33 - Enable or Disable Thermal Reporting
  Enable or Disable Thermal Reporting through ACPI tables; 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       EnableAllThermalFunctions;

/** Offset 0x1C34 - Enable or Disable Thermal Monitor
  Enable or Disable Thermal Monitor; 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       ThermalMonitor;

/** Offset 0x1C35 - Enable or Disable CPU power states (C-states)
  Enable/Disable CPU Power Management. Allows CPU to go to C states when it's not
  100% utilized. 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       Cx;

/** Offset 0x1C36 - Configure C-State Configuration Lock
  Configure MSR to CFG Lock bit. 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       PmgCstCfgCtrlLock;

/** Offset 0x1C37 - Enable or Disable Enhanced C-states
  Enable/Disable C1E. When enabled, CPU will switch to minimum speed when all cores
  enter C-State. 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       C1e;

/** Offset 0x1C38 - Enable or Disable Package Cstate Demotion
  Enable or Disable Package C-State Demotion. 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       PkgCStateDemotion;

/** Offset 0x1C39 - Enable or Disable Package Cstate UnDemotion
  Enable or Disable Package C-State Un-Demotion. 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       PkgCStateUnDemotion;

/** Offset 0x1C3A - Enable or Disable CState-Pre wake
  Disable - to disable the Cstate Pre-Wake. 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       CStatePreWake;

/** Offset 0x1C3B - Enable or Disable TimedMwait Support.
  Enable or Disable TimedMwait Support. <b>0: Disable</b>; 1: Enable
  $EN_DIS
**/
  UINT8                       TimedMwait;

/** Offset 0x1C3C - Enable or Disable IO to MWAIT redirection
  When set, will map IO_read instructions sent to IO registers PMG_IO_BASE_ADDRBASE+offset
  to MWAIT(offset). <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       CstCfgCtrIoMwaitRedirection;

/** Offset 0x1C3D - Set the Max Pkg Cstate
  Maximum Package C State Limit Setting. Cpu Default: Leaves to Factory default value.
  Auto: Initializes to deepest available Package C State Limit. Valid values 0 -
  C0/C1, 1 - C2, 2 - C3, 3 - C6, 4 - C7, 5 - C7S, 6 - C8, 7 - C9, 8 - C10, 254 -
  CPU Default, <b>255 - Auto</b>
**/
  UINT8                       PkgCStateLimit;

/** Offset 0x1C3E - Interrupt Redirection Mode Select
  Interrupt Redirection Mode Select for Logical Interrupts. 0: Fixed priority; 1:
  Round robin; 2: Hash vector; 7: No change.
**/
  UINT8                       PpmIrmSetting;

/** Offset 0x1C3F - Lock prochot configuration
  Lock prochot configuration Enable/Disable; 0: Disable;<b> 1: Enable</b>
  $EN_DIS
**/
  UINT8                       ProcHotLock;

/** Offset 0x1C40 - Configuration for boot TDP selection
  cTDP(Assured Power) Mode as Nominal/Level1/Level2/Deactivate TDP(Base Power) selection.
  Deactivate option will set MSR to Nominal and MMIO to Zero. <b>0: TDP(Base Power)
  Nominal</b>; 1: TDP(Base Power) Down; 2: TDP(Base Power) Up;0xFF : Deactivate
**/
  UINT8                       ConfigTdpLevel;

/** Offset 0x1C41 - Max P-State Ratio
  Maximum P-state ratio to use in the custom P-state table. Valid Range 0 to 0x7F
**/
  UINT8                       MaxRatio;

/** Offset 0x1C42 - P-state ratios for custom P-state table
  P-state ratios for custom P-state table. NumberOfEntries has valid range between
  0 to 40. For no. of P-States supported(NumberOfEntries) , StateRatio[NumberOfEntries]
  are configurable. Valid Range of each entry is 0 to 0x7F
**/
  UINT8                       StateRatio[40];

/** Offset 0x1C6A - P-state ratios for max 16 version of custom P-state table
  P-state ratios for max 16 version of custom P-state table. This table is used for
  OS versions limited to a max of 16 P-States. If the first entry of this table is
  0, or if Number of Entries is 16 or less, then this table will be ignored, and
  up to the top 16 values of the StateRatio table will be used instead. Valid Range
  of each entry is 0 to 0x7F
**/
  UINT8                       StateRatioMax16[16];

/** Offset 0x1C7A
**/
  UINT8                       Rsvd400[2];

/** Offset 0x1C7C - Package Long duration turbo mode power limit
  Power Limit 1 in Milli Watts. BIOS will round to the nearest 1/8W when programming.
  Value set 120 = 15W. 0 = no custom override. Overclocking SKU: Value must be between
  Max and Min Power Limits. Other SKUs: This value must be between Min Power Limit
  and Processor Base Power (TDP) Limit. If value is 0, BIOS will program Processor
  Base Power (TDP) value. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit. Valid
  Range 0 to 32767.
**/
  UINT32                      PowerLimit1;

/** Offset 0x1C80 - Package Short duration turbo mode power limit
  Power Limit 2 in Milli Watts. BIOS will round to the nearest 1/8W when programming.
  Value set 120 = 15W. If the value is 0, BIOS will program this value as 1.25*Processor
  Base Power (TDP). Processor applies control policies such that the package power
  does not exceed this limit. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.
  Valid Range 0 to 32767.
**/
  UINT32                      PowerLimit2Power;

/** Offset 0x1C84 - Package PL3 power limit
  Power Limit 3 in Milli Watts. BIOS will round to the nearest 1/8W when programming.
  Value set 120 = 15W. XE SKU: Any value can be programmed. Overclocking SKU: Value
  must be between Max and Min Power Limits. Other SKUs: This value must be between
  Min Power Limit and Processor Base Power (TDP) Limit. If the value is 0, BIOS leaves
  the hardware default value. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.
  Valid Range 0 to 32767.
**/
  UINT32                      PowerLimit3;

/** Offset 0x1C88 - Package PL4 power limit
  Power Limit 4 in Milli Watts. BIOS will round to the nearest 1/8W when programming.
  Value set 120 = 15W. If the value is 0, BIOS leaves default value. Units are based
  on POWER_MGMT_CONFIG.CustomPowerUnit. Valid Range 0 to 32767.
**/
  UINT32                      PowerLimit4;

/** Offset 0x1C8C - Package PL4 boost configuration
  Configure Power Limit 4 Boost in Watts. Valid Range 0 to 1023 in step size of 1
  Watt. The value 0 means disable.
**/
  UINT16                      PowerLimit4Boost;

/** Offset 0x1C8E
**/
  UINT8                       Rsvd410[2];

/** Offset 0x1C90 - Tcc Offset Time Window for RATL
**/
  UINT32                      TccOffsetTimeWindowForRatl;

/** Offset 0x1C94 - Short term Power Limit value for custom cTDP level 1
  Power Limit 1 in Milli Watts. BIOS will round to the nearest 1/8W when programming.
  Value set 120 = 15W. 0 = no custom override. Overclocking SKU: Value must be between
  Max and Min Power Limits. Other SKUs: This value must be between Min Power Limit
  and Processor Base Power (TDP) Limit. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.
  Valid Range 0 to 32767.
**/
  UINT32                      Custom1PowerLimit1;

/** Offset 0x1C98 - Long term Power Limit value for custom cTDP level 1
  Power Limit 2 value in Milli Watts. BIOS will round to the nearest 1/8W when programming.
  Value set 120 = 15W. 0 = no custom override. Processor applies control policies
  such that the package power does not exceed this limit. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.
  Valid Range 0 to 32767.
**/
  UINT32                      Custom1PowerLimit2;

/** Offset 0x1C9C - Short term Power Limit value for custom cTDP level 2
  Power Limit 1 in Milli Watts. BIOS will round to the nearest 1/8W when programming.
  Value set 120 = 15W. 0 = no custom override. Overclocking SKU: Value must be between
  Max and Min Power Limits. Other SKUs: This value must be between Min Power Limit
  and Processor Base Power (TDP) Limit. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.
  Valid Range 0 to 32767.
**/
  UINT32                      Custom2PowerLimit1;

/** Offset 0x1CA0 - Long term Power Limit value for custom cTDP level 2
  Power Limit 2 value in Milli Watts. BIOS will round to the nearest 1/8W when programming.
  Value set 120 = 15W. 0 = no custom override. Processor applies control policies
  such that the package power does not exceed this limit. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.
  Valid Range 0 to 32767.
**/
  UINT32                      Custom2PowerLimit2;

/** Offset 0x1CA4 - Short term Power Limit value for custom cTDP level 3
  Power Limit 1 in Milli Watts. BIOS will round to the nearest 1/8W when programming.
  Value set 120 = 15W. 0 = no custom override. Overclocking SKU: Value must be between
  Max and Min Power Limits. Other SKUs: This value must be between Min Power Limit
  and Processor Base Power (TDP) Limit. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.
  Valid Range 0 to 32767.
**/
  UINT32                      Custom3PowerLimit1;

/** Offset 0x1CA8 - Long term Power Limit value for custom cTDP level 3
  Power Limit 2 value in Milli Watts. BIOS will round to the nearest 1/8W when programming.
  Value set 120 = 15W. 0 = no custom override. Processor applies control policies
  such that the package power does not exceed this limit. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.
  Valid Range 0 to 32767.
**/
  UINT32                      Custom3PowerLimit2;

/** Offset 0x1CAC - Platform PL1 power
  Platform Power Limit 1 Power in Milli Watts. BIOS will round to the nearest 1/8W
  when programming. Value set 120 = 15W. Any value can be programmed between Max
  and Min Power Limits. This setting will act as the new PL1 value for the Package
  RAPL algorithm. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit. Valid Range
  0 to 32767.
**/
  UINT32                      PsysPowerLimit1Power;

/** Offset 0x1CB0 - Platform PL2 power
  Platform Power Limit 2 Power in Milli Watts. BIOS will round to the nearest 1/8W
  when programming. Value set 120 = 15W. Any value can be programmed between Max
  and Min Power Limits. This setting will act as the new Max Turbo Power (PL2) value
  for the Package RAPL algorithm. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.
  Valid Range 0 to 32767.
**/
  UINT32                      PsysPowerLimit2Power;

/** Offset 0x1CB4 - CCF AutoGV
  Enable/Disable CCF AutoGV; 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       CcfAutoGv;

/** Offset 0x1CB5 - Race To Halt
  Enable/Disable Race To Halt feature. RTH will dynamically increase CPU frequency
  in order to enter pkg C-State faster to reduce overall power. 0: Disable; <b>1:
  Enable</b>
  $EN_DIS
**/
  UINT8                       RaceToHalt;

/** Offset 0x1CB6 - Enable or Disable Three Strike Counter
  Enable (default): Three Strike counter will be incremented. Disable: Prevents Three
  Strike counter from incrementing; 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       ThreeStrikeCounter;

/** Offset 0x1CB7 - Set HW P-State Interrupts Enabled for for MISC_PWR_MGMT
  Set HW P-State Interrupts Enabled for for MISC_PWR_MGMT; <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       HwpInterruptControl;

/** Offset 0x1CB8 - ReservedCpuPostMem2
  Reserved for CPU Post-Mem 2
  $EN_DIS
**/
  UINT8                       ReservedCpuPostMem2[4];

/** Offset 0x1CBC - Enable or Disable C1 Cstate Demotion
  Enable or Disable C1 Cstate Auto Demotion. Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       C1StateAutoDemotion;

/** Offset 0x1CBD - Enable or Disable C1 Cstate UnDemotion
  Enable or Disable C1 Cstate Un-Demotion. Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       C1StateUnDemotion;

/** Offset 0x1CBE - Minimum Ring ratio limit override
  Minimum Ring ratio limit override. <b>0: Hardware defaults.</b> Range: 0 - Max turbo
  ratio limit
**/
  UINT8                       MinRingRatioLimit;

/** Offset 0x1CBF - Maximum Ring ratio limit override
  Maximum Ring ratio limit override. <b>0: Hardware defaults.</b> Range: 0 - Max turbo
  ratio limit
**/
  UINT8                       MaxRingRatioLimit;

/** Offset 0x1CC0 - Enable or Disable Per Core P State OS control
  Enable/Disable Per Core P state OS control mode. When set, the highest core request
  is used for all other core requests. 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       EnablePerCorePState;

/** Offset 0x1CC1 - Enable or Disable HwP Autonomous Per Core P State OS control
  Disable Autonomous PCPS Autonomous will request the same value for all cores all
  the time. 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       EnableHwpAutoPerCorePstate;

/** Offset 0x1CC2 - Enable or Disable HwP Autonomous EPP Grouping
  Enable EPP grouping Autonomous will request the same values for all cores with same
  EPP. Disable EPP grouping autonomous will not necessarily request same values for
  all cores with same EPP. <b> 0: Disable </b>; 1: Enable
  $EN_DIS
**/
  UINT8                       EnableHwpAutoEppGrouping;

/** Offset 0x1CC3 - Enable Configurable TDP
  Applies cTDP(Assured Power) initialization settings based on non-cTDP(Assured Power)
  or cTDP(Assured Power). Default is 1: Applies to cTDP(Assured Power); if 0 then
  applies non-cTDP(Assured Power) and BIOS will bypass cTDP(Assured Power) initialzation flow
  $EN_DIS
**/
  UINT8                       ApplyConfigTdp;

/** Offset 0x1CC4 - Misc Power Management MSR Lock
  Enable/Disable HWP Lock support in Misc Power Management MSR. 0: Disable, <b>1:
  Enable </b>
  $EN_DIS
**/
  UINT8                       HwpLock;

/** Offset 0x1CC5 - Dual Tau Boost
  Enable Dual Tau Boost feature. This is only applicable for Desktop 35W/65W/125W
  sku. When DPTF is enabled this feature is ignored. <b>0: Disable</b>; 1: Enable
  $EN_DIS
**/
  UINT8                       DualTauBoost;

/** Offset 0x1CC6 - Response Mode
  Use Response Mode to adjust Psys_PL3 power reduction behavior. Battery-enabled systems
  use Gradual Power Reduction. <b>0: Gradual Power Reduction</b> ; 1: Aggressive
  Power Reduction
  0: Gradual Power Reduction, 1: Aggressive Power Reduction
**/
  UINT8                       StepDownMode;

/** Offset 0x1CC7 - Power Floor Managment for SOC
  Option to disable Power Floor Managment for SOC. Disabling this might effectively
  raise power floor of the SoC and may lead to stability issues. 0: Disable, <b>1:
  Enable </b>
  $EN_DIS
**/
  UINT8                       PowerFloorManagement;

/** Offset 0x1CC8 - Power Floor Disaplay Disconnect
  SoC can disconnect secondary/external display to lower SoC floor power (Default
  enabled).  0: Disable: Display disconnect will not be used by SoC., <b>1: Enable </b>
  $EN_DIS
**/
  UINT8                       PowerFloorDisplayDisconnect;

/** Offset 0x1CC9 - Resource Priority Feature
  Enable/Disable Resource Priority Feature. Enable/Disable;  <b>0: Disable</b> ; 1:Enable
  $EN_DIS
**/
  UINT8                       EnableRp;

/** Offset 0x1CCA - Power Floor PCIe Gen Downgrade
  SoC can downgrade PCIe gen speed to lower SoC floor power (Default enabled).  0:
  Disable: Reduction in PCIe gen speed will not be used by SoC., <b>1: Enable </b>
  $EN_DIS
**/
  UINT8                       PowerFloorPcieGenDowngrade;

/** Offset 0x1CCB - ReservedCpuPostMemTest
  Reserved for CPU Post-Mem Test
  $EN_DIS
**/
  UINT8                       ReservedCpuPostMemTest[13];

/** Offset 0x1CD8
**/
  UINT8                       SecurityPostMemRsvd[16];

/** Offset 0x1CE8 - End of Post message
  Test, Send End of Post message. Disable(0x0): Disable EOP message, Send in PEI(0x1):
  EOP send in PEI, Send in DXE(0x2)(Default): EOP send in DXE
  0:Disable, 1:Send in PEI, 2:Send in DXE, 3:Reserved
**/
  UINT8                       EndOfPostMessage;

/** Offset 0x1CE9 - D0I3 Setting for HECI Disable
  Test, 0: disable, 1: enable, Setting this option disables setting D0I3 bit for all
  HECI devices
  $EN_DIS
**/
  UINT8                       DisableD0I3SettingForHeci;

/** Offset 0x1CEA - Mctp Broadcast Cycle
  Test, Determine if MCTP Broadcast is enabled <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       MctpBroadcastCycle;

/** Offset 0x1CEB - ME Unconfig on RTC clear
  0: Disable ME Unconfig On Rtc Clear. <b>1: Enable ME Unconfig On Rtc Clear</b>.
  2: Cmos is clear, status unkonwn. 3: Reserved
  0: Disable ME Unconfig On Rtc Clear, 1: Enable ME Unconfig On Rtc Clear, 2: Cmos
  is clear, 3: Reserved
**/
  UINT8                       MeUnconfigOnRtcClear;

/** Offset 0x1CEC - Enforce Enhanced Debug Mode
  Determine if ME should enter Enhanced Debug Mode. <b>0: disable</b>, 1: enable
  $EN_DIS
**/
  UINT8                       EnforceEDebugMode;

/** Offset 0x1CED - CSE Data Resilience Support
  0: Disable CSE Data Resilience Support. <b>1: Enable CSE Data Resilience Support.</b>
  $EN_DIS
**/
  UINT8                       CseDataResilience;

/** Offset 0x1CEE - MePostMemRsvd
  Reserved for ME Post-Mem
  $EN_DIS
**/
  UINT8                       MePostMemRsvd[16];

/** Offset 0x1CFE - Enable LOCKDOWN SMI
  Enable SMI_LOCK bit to prevent writes to the Global SMI Enable bit.
  $EN_DIS
**/
  UINT8                       PchLockDownGlobalSmi;

/** Offset 0x1CFF - Enable LOCKDOWN BIOS Interface
  Enable BIOS Interface Lock Down bit to prevent writes to the Backup Control Register.
  $EN_DIS
**/
  UINT8                       PchLockDownBiosInterface;

/** Offset 0x1D00 - Unlock all GPIO pads
  Force all GPIO pads to be unlocked for debug purpose.
  $EN_DIS
**/
  UINT8                       PchUnlockGpioPads;

/** Offset 0x1D01 - PCH Unlock SideBand access
  The SideBand PortID mask for certain end point (e.g. PSFx) will be locked before
  3rd party code execution. 0: Lock SideBand access; 1: Unlock SideBand access.
  $EN_DIS
**/
  UINT8                       PchSbAccessUnlock;

/** Offset 0x1D02
**/
  UINT8                       Rsvd420[2];

/** Offset 0x1D04 - PCIE RP Ltr Max Snoop Latency
  Latency Tolerance Reporting, Max Snoop Latency.
**/
  UINT16                      PcieRpLtrMaxSnoopLatency[29];

/** Offset 0x1D3E - PCIE RP Ltr Max No Snoop Latency
  Latency Tolerance Reporting, Max Non-Snoop Latency.
**/
  UINT16                      PcieRpLtrMaxNoSnoopLatency[29];

/** Offset 0x1D78 - PCIE RP Snoop Latency Override Mode
  Latency Tolerance Reporting, Snoop Latency Override Mode.
**/
  UINT8                       PcieRpSnoopLatencyOverrideMode[29];

/** Offset 0x1D95 - PCIE RP Snoop Latency Override Multiplier
  Latency Tolerance Reporting, Snoop Latency Override Multiplier.
**/
  UINT8                       PcieRpSnoopLatencyOverrideMultiplier[29];

/** Offset 0x1DB2 - PCIE RP Snoop Latency Override Value
  Latency Tolerance Reporting, Snoop Latency Override Value.
**/
  UINT16                      PcieRpSnoopLatencyOverrideValue[29];

/** Offset 0x1DEC - PCIE RP Non Snoop Latency Override Mode
  Latency Tolerance Reporting, Non-Snoop Latency Override Mode.
**/
  UINT8                       PcieRpNonSnoopLatencyOverrideMode[29];

/** Offset 0x1E09 - PCIE RP Non Snoop Latency Override Multiplier
  Latency Tolerance Reporting, Non-Snoop Latency Override Multiplier.
**/
  UINT8                       PcieRpNonSnoopLatencyOverrideMultiplier[29];

/** Offset 0x1E26 - PCIE RP Non Snoop Latency Override Value
  Latency Tolerance Reporting, Non-Snoop Latency Override Value.
**/
  UINT16                      PcieRpNonSnoopLatencyOverrideValue[29];

/** Offset 0x1E60 - PCIE RP Slot Power Limit Scale
  Specifies scale used for slot power limit value. Leave as 0 to set to default.
**/
  UINT8                       PcieRpSlotPowerLimitScale[29];

/** Offset 0x1E7D
**/
  UINT8                       Rsvd430[1];

/** Offset 0x1E7E - PCIE RP Slot Power Limit Value
  Specifies upper limit on power supplie by slot. Leave as 0 to set to default.
**/
  UINT16                      PcieRpSlotPowerLimitValue[29];

/** Offset 0x1EB8 - PCIE RP Enable Port8xh Decode
  This member describes whether PCIE root port Port 8xh Decode is enabled. 0: Disable;
  1: Enable.
  $EN_DIS
**/
  UINT8                       PcieEnablePort8xhDecode;

/** Offset 0x1EB9 - PCIE Port8xh Decode Port Index
  The Index of PCIe Port that is selected for Port8xh Decode (0 Based).
**/
  UINT8                       PchPciePort8xhDecodePortIndex;

/** Offset 0x1EBA - PCH Energy Reporting
  Disable/Enable PCH to CPU energy report feature.
  $EN_DIS
**/
  UINT8                       PchPmDisableEnergyReport;

/** Offset 0x1EBB - PCH Sata Test Mode
  Allow entrance to the PCH SATA test modes.
  $EN_DIS
**/
  UINT8                       SataTestMode;

/** Offset 0x1EBC - PCH USB OverCurrent mapping lock enable
  If this policy option is enabled then BIOS will program OCCFDONE bit in xHCI meaning
  that OC mapping data will be consumed by xHCI and OC mapping registers will be locked.
  $EN_DIS
**/
  UINT8                       PchXhciOcLock;

/** Offset 0x1EBD - Low Power Mode Enable/Disable config mask
  Configure if respective S0i2/3 sub-states are to be supported. Each bit corresponds
  to one sub-state (LPMx - BITx): LPM0-s0i2.0, LPM1-s0i2.1, LPM2-s0i2.2, LPM3-s0i3.0,
  LPM4-s0i3.1, LPM5-s0i3.2, LPM6-s0i3.3, LPM7-s0i3.4.
**/
  UINT8                       PmcLpmS0ixSubStateEnableMask;

/** Offset 0x1EBE - Low Power Mode Enable/Disable config mask
  Configure if respective S0i2/3 sub-states are to be supported. Each bit corresponds
  to one sub-state (LPMx - BITx): LPM0-s0i2.0, LPM1-s0i2.1, LPM2-s0i2.2, LPM3-s0i3.0,
  LPM4-s0i3.1, LPM5-s0i3.2, LPM6-s0i3.3, LPM7-s0i3.4.
**/
  UINT8                       PmcPchLpmS0ixSubStateEnableMask;

/** Offset 0x1EBF - PCH PMC ER Debug mode
  Disable/Enable Energy Reporting Debug Mode.
  $EN_DIS
**/
  UINT8                       PchPmErDebugMode;

/** Offset 0x1EC0 - CPPM Forced Alignment Enable
  Enable/Disable CPPM Force Alignment. When enabled, PMC allows stalling of the backbone
  or blocking the DMI transmit arbiter
  $EN_DIS
**/
  UINT8                       CppmFaEn;

/** Offset 0x1EC1 - PCH Lan WOL Fast Support
  Enables bit B_PCH_ACPI_GPE0_EN_127_96_PME_B0 during PchLanSxCallback in PchLanSxSmm.
  $EN_DIS
**/
  UINT8                       PchLanWOLFastSupport;

/** Offset 0x1EC2 - Platform ATX Telemetry Unit
  Set ATX Telemetry Unit in Watts or Percentage; <b>0: Watts</b>; 1: Percent
  $EN_DIS
**/
  UINT8                       PlatformAtxTelemetryUnit;

/** Offset 0x1EC3 - PCIE RP LTR Override Spec Complaint
  Override LTR based on Ep capability.
**/
  UINT8                       PcieRpLtrOverrideSpecComplaint[29];

/** Offset 0x1EE0
**/
  UINT8                       PchMeFspsUpdRsvd[71];

/** Offset 0x1F27 - PMC C10 dynamic threshold dajustment enable
  Set if you want to enable PMC C10 dynamic threshold adjustment. Only works on supported SKUs
  $EN_DIS
**/
  UINT8                       PmcC10DynamicThresholdAdjustment;

/** Offset 0x1F28 - Turbo Ratio Limit Ratio array
  Performance-core Turbo Ratio Limit Ratio0-7 (TRLR) defines the turbo ratio (max
  is 85 in normal mode and 120 in core extension mode). Ratio[0]: This Turbo Ratio
  Limit Ratio0 must be greater than or equal all other ratio values. If this value
  is invalid, thn set all other active cores to minimum. Otherwise, align the Ratio
  Limit to 0. Please check each active cores. Ratio[1~7]: This Turbo Ratio Limit
  Ratio1 must be <= to Turbo Ratio Limit Ratio0~6.
**/
  UINT8                       TurboRatioLimitRatio[8];

/** Offset 0x1F30 - Turbo Ratio Limit Num Core array
  Performance-core Turbo Ratio Limit Core0~7 defines the core range, the turbo ratio
  is defined in Turbo Ratio Limit Ratio0~7. If value is zero, this entry is ignored.
**/
  UINT8                       TurboRatioLimitNumCore[8];

/** Offset 0x1F38 - ATOM Turbo Ratio Limit Ratio array
  Efficient-core Turbo Ratio Limit Ratio0-7 defines the turbo ratio (max is 85 irrespective
  of the core extension mode), the core range is defined in E-core Turbo Ratio Limit
  CoreCount0-7.
**/
  UINT8                       AtomTurboRatioLimitRatio[8];

/** Offset 0x1F40 - ATOM Turbo Ratio Limit Num Core array
  Efficient-core Turbo Ratio Limit CoreCount0-7 defines the core range, the turbo
  ratio is defined in E-core Turbo Ratio Limit Ratio0-7. If value is zero, this entry
  is ignored.
**/
  UINT8                       AtomTurboRatioLimitNumCore[8];

/** Offset 0x1F48
**/
  UINT8                       Rsvd440[4];

/** Offset 0x1F4C - FspEventHandler
  <b>Optional</b> pointer to the boot loader's implementation of FSP_EVENT_HANDLER.
**/
  UINT32                      FspEventHandler;

/** Offset 0x1F50 - Type C Port x Convert to TypeA
  Enable / Disable(default) Type C Port x Convert to TypeA
  $EN_DIS
**/
  UINT8                       EnableTcssCovTypeA[4];

/** Offset 0x1F54
**/
  UINT8                       Rsvd450[16];

/** Offset 0x1F64
**/
  UINT8                       ReservedFspsUpd[12];
} FSP_S_CONFIG;

/** Fsp S UPD Configuration
**/
typedef struct {

/** Offset 0x0000
**/
  FSP_UPD_HEADER              FspUpdHeader;

/** Offset 0x0020
**/
  FSPS_ARCH_UPD               FspsArchUpd;

/** Offset 0x0040
**/
  FSP_S_CONFIG                FspsConfig;

/** Offset 0x1F70
**/
  UINT8                       Rsvd600[6];

/** Offset 0x1F76
**/
  UINT16                      UpdTerminator;
} FSPS_UPD;

#pragma pack()

#endif
