/* SPDX-License-Identifier: GPL-2.0-only */

#include <assert.h>
#include <stdint.h>

/*
 * EC communication interface for ITE Embedded Controller
 */

#ifndef _EC_STARLABS_KBL_EC_DEFS_H
#define _EC_STARLABS_KBL_EC_DEFS_H

/* EC RAM offsets */
#define ECRAM_MAJOR_VERSION		0x00
#define ECRAM_MINOR_VERSION		0x01
#define ECRAM_TRACKPAD_STATE		0x14
#define ECRAM_KBL_STATE			0x18
#define ECRAM_KBL_BRIGHTNESS		0x19
#define ECRAM_KBL_TIMEOUT		0x1a
#define ECRAM_FN_LOCK_STATE		0x2c
#define ECRAM_FAN_MODE			0x42
#define ECRAM_FN_CTRL_REVERSE		0x43
#define ECRAM_MAX_CHARGE		dead_code_t(uint8_t)
#define ECRAM_CHARGING_SPEED		dead_code_t(uint8_t)
#define ECRAM_LID_SWITCH		dead_code_t(uint8_t)
#define ECRAM_POWER_LED			0x1f
#define ECRAM_BATTERY_DESIGN_CAPACITY	0x84
#define ECRAM_BATTERY_DESIGN_VOLTAGE	0x86

#endif
